/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.notify.ThreadPoolNotifyAlarm;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.core.executor.DynamicThreadPool;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.AbstractDynamicExecutorSupport;
import cn.hippo4j.core.executor.support.CommonDynamicThreadPool;
import cn.hippo4j.core.executor.support.QueueTypeEnum;
import cn.hippo4j.core.executor.support.RejectedTypeEnum;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.toolkit.inet.DynamicThreadPoolAnnotationUtil;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.ServerThreadPoolDynamicRefresh;
import cn.hippo4j.starter.core.ThreadPoolOperation;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hutool.core.util.BooleanUtil;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.TaskDecorator;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapProperties properties;
    private final HttpAgent httpAgent;
    private final ThreadPoolOperation threadPoolOperation;
    private final ServerThreadPoolDynamicRefresh threadPoolDynamicRefresh;
    private final ExecutorService executorService = ThreadPoolBuilder.builder().corePoolSize(2).maxPoolNum(4).keepAliveTime(2000L).timeUnit(TimeUnit.MILLISECONDS).workQueue(QueueTypeEnum.ARRAY_BLOCKING_QUEUE).capacity(1024).allowCoreThreadTimeOut(true).threadFactory("client.dynamic.threadPool.change.config").rejected((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()).build();

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor) {
            try {
                DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
                if (Objects.isNull(dynamicThreadPool) && Objects.isNull(dynamicThreadPool = (DynamicThreadPool)DynamicThreadPoolAnnotationUtil.findAnnotationOnBean((String)beanName, DynamicThreadPool.class))) {
                    return bean;
                }
            }
            catch (Exception ex) {
                log.error("Failed to create dynamic thread pool in annotation mode.", (Throwable)ex);
                return bean;
            }
            DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)bean;
            DynamicThreadPoolWrapper wrap = new DynamicThreadPoolWrapper(dynamicExecutor.getThreadPoolId(), (ThreadPoolExecutor)dynamicExecutor);
            ThreadPoolExecutor remoteExecutor = this.fillPoolAndRegister(wrap);
            this.subscribeConfig(wrap);
            return remoteExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper wrap = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(wrap);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        this.fillPoolAndRegister(dynamicThreadPoolWrap);
        this.subscribeConfig(dynamicThreadPoolWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        String tpId = dynamicThreadPoolWrap.getTpId();
        HashMap<String, String> queryStrMap = new HashMap<String, String>(3);
        queryStrMap.put("tpId", tpId);
        queryStrMap.put("itemId", this.properties.getItemId());
        queryStrMap.put("namespace", this.properties.getNamespace());
        boolean isSubscribe = false;
        ThreadPoolExecutor newDynamicPoolExecutor = null;
        PoolParameterInfo ppi = new PoolParameterInfo();
        try {
            String resultJsonStr;
            Result result = this.httpAgent.httpGetByConfig("/hippo4j/v1/cs/configs", null, queryStrMap, 5000L);
            if (result.isSuccess() && result.getData() != null && (ppi = (PoolParameterInfo)JSONUtil.parseObject((String)(resultJsonStr = JSONUtil.toJSONString((Object)result.getData())), PoolParameterInfo.class)) != null) {
                BlockingQueue workQueue = QueueTypeEnum.createBlockingQueue((int)ppi.getQueueType(), (Integer)ppi.getCapacity());
                newDynamicPoolExecutor = ThreadPoolBuilder.builder().dynamicPool().workQueue(workQueue).threadFactory(tpId).poolThreadSize(ppi.getCoreSize().intValue(), ppi.getMaxSize().intValue()).keepAliveTime((long)ppi.getKeepAliveTime().intValue(), TimeUnit.SECONDS).rejected(RejectedTypeEnum.createPolicy((int)ppi.getRejectedType())).allowCoreThreadTimeOut(EnableEnum.getBool((Integer)ppi.getAllowCoreThreadTimeOut())).build();
                if (dynamicThreadPoolWrap.getExecutor() instanceof AbstractDynamicExecutorSupport) {
                    ThreadPoolNotifyAlarm threadPoolNotifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(BooleanUtil.toBoolean((String)ppi.getIsAlarm().toString())), ppi.getCapacityAlarm(), ppi.getLivenessAlarm());
                    GlobalNotifyAlarmManage.put((String)tpId, (ThreadPoolNotifyAlarm)threadPoolNotifyAlarm);
                    TaskDecorator taskDecorator = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).getTaskDecorator();
                    ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setTaskDecorator(taskDecorator);
                    long awaitTerminationMillis = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).awaitTerminationMillis;
                    boolean waitForTasksToCompleteOnShutdown = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).waitForTasksToCompleteOnShutdown;
                    ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setSupportParam(awaitTerminationMillis, waitForTasksToCompleteOnShutdown);
                    long executeTimeOut = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).getExecuteTimeOut();
                    ((DynamicThreadPoolExecutor)newDynamicPoolExecutor).setExecuteTimeOut(Long.valueOf(executeTimeOut));
                }
                dynamicThreadPoolWrap.setExecutor(newDynamicPoolExecutor);
                isSubscribe = true;
            }
        }
        catch (Exception ex) {
            newDynamicPoolExecutor = dynamicThreadPoolWrap.getExecutor() != null ? dynamicThreadPoolWrap.getExecutor() : CommonDynamicThreadPool.getInstance((String)tpId);
            dynamicThreadPoolWrap.setExecutor(newDynamicPoolExecutor);
            log.error("Failed to initialize thread pool configuration. error message :: {}", (Object)ex.getMessage());
        }
        finally {
            if (Objects.isNull(dynamicThreadPoolWrap.getExecutor())) {
                dynamicThreadPoolWrap.setExecutor((ThreadPoolExecutor)CommonDynamicThreadPool.getInstance((String)tpId));
            }
            dynamicThreadPoolWrap.setSubscribeFlag(isSubscribe);
        }
        GlobalThreadPoolManage.register((String)dynamicThreadPoolWrap.getTpId(), (PoolParameter)ppi, (DynamicThreadPoolWrapper)dynamicThreadPoolWrap);
        return newDynamicPoolExecutor;
    }

    protected void subscribeConfig(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        if (dynamicThreadPoolWrap.isSubscribeFlag()) {
            this.threadPoolOperation.subscribeConfig(dynamicThreadPoolWrap.getTpId(), this.executorService, config -> this.threadPoolDynamicRefresh.dynamicRefresh(config));
        }
    }

    public DynamicThreadPoolPostProcessor(BootstrapProperties properties, HttpAgent httpAgent, ThreadPoolOperation threadPoolOperation, ServerThreadPoolDynamicRefresh threadPoolDynamicRefresh) {
        this.properties = properties;
        this.httpAgent = httpAgent;
        this.threadPoolOperation = threadPoolOperation;
        this.threadPoolDynamicRefresh = threadPoolDynamicRefresh;
    }
}

