/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.controller;

import cn.hippo4j.common.model.PoolBaseInfo;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import cn.hippo4j.starter.handler.web.WebThreadPoolHandlerChoose;
import cn.hippo4j.starter.handler.web.WebThreadPoolRunStateHandler;
import cn.hippo4j.starter.handler.web.WebThreadPoolService;
import java.util.concurrent.Executor;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
public class WebThreadPoolController {
    private final WebThreadPoolHandlerChoose webThreadPoolServiceChoose;
    private final WebThreadPoolRunStateHandler webThreadPoolRunStateHandler;

    @GetMapping(value={"/web/base/info"})
    public Result<PoolBaseInfo> getPoolBaseState() {
        WebThreadPoolService webThreadPoolService = this.webThreadPoolServiceChoose.choose();
        Executor webThreadPool = webThreadPoolService.getWebThreadPool();
        PoolBaseInfo poolBaseInfo = this.webThreadPoolRunStateHandler.simpleInfo(webThreadPool);
        return Results.success((Object)poolBaseInfo);
    }

    @GetMapping(value={"/web/run/state"})
    public Result<PoolRunStateInfo> getPoolRunState() {
        WebThreadPoolService webThreadPoolService = this.webThreadPoolServiceChoose.choose();
        Executor webThreadPool = webThreadPoolService.getWebThreadPool();
        PoolRunStateInfo poolRunState = this.webThreadPoolRunStateHandler.getPoolRunState(null, webThreadPool);
        return Results.success((Object)poolRunState);
    }

    @PostMapping(value={"/web/update/pool"})
    public Result<Void> updateWebThreadPool(@RequestBody PoolParameterInfo poolParameterInfo) {
        WebThreadPoolService webThreadPoolService = this.webThreadPoolServiceChoose.choose();
        webThreadPoolService.updateWebThreadPool(poolParameterInfo);
        return Results.success();
    }

    public WebThreadPoolController(WebThreadPoolHandlerChoose webThreadPoolServiceChoose, WebThreadPoolRunStateHandler webThreadPoolRunStateHandler) {
        this.webThreadPoolServiceChoose = webThreadPoolServiceChoose;
        this.webThreadPoolRunStateHandler = webThreadPoolRunStateHandler;
    }
}

