/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.config;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.DiscoveryClient;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.toolkit.CloudCommonIdUtil;
import cn.hutool.core.text.StrBuilder;
import java.net.InetAddress;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class DiscoveryConfiguration {
    private final ConfigurableEnvironment environment;
    private final BootstrapProperties properties;
    private final InetUtils hippo4JInetUtils;

    @Bean
    public InstanceInfo instanceConfig() {
        String namespace = this.properties.getNamespace();
        String itemId = this.properties.getItemId();
        String port = this.environment.getProperty("server.port", "8080");
        String applicationName = this.environment.getProperty("spring.dynamic.thread-pool.item-id");
        String active = this.environment.getProperty("spring.profiles.active", "UNKNOWN");
        InstanceInfo instanceInfo = new InstanceInfo();
        String instanceId = CloudCommonIdUtil.getDefaultInstanceId((PropertyResolver)this.environment, this.hippo4JInetUtils);
        instanceId = StrBuilder.create().append((CharSequence)instanceId).append((CharSequence)":").append((CharSequence)IdentifyUtil.CLIENT_IDENTIFICATION_VALUE).toString();
        String contextPath = this.environment.getProperty("server.servlet.context-path", "");
        instanceInfo.setInstanceId(instanceId).setIpApplicationName(CloudCommonIdUtil.getIpApplicationName((PropertyResolver)this.environment, this.hippo4JInetUtils)).setHostName(InetAddress.getLocalHost().getHostAddress()).setGroupKey(itemId + "+" + namespace).setAppName(applicationName).setPort(port).setClientBasePath(contextPath).setGroupKey(ContentUtil.getGroupKey((String[])new String[]{itemId, namespace}));
        String callBackUrl = instanceInfo.getHostName() + ":" + port + instanceInfo.getClientBasePath();
        instanceInfo.setCallBackUrl(callBackUrl);
        String identify = IdentifyUtil.generate((ConfigurableEnvironment)this.environment, (InetUtils)this.hippo4JInetUtils);
        instanceInfo.setIdentify(identify);
        instanceInfo.setActive(active.toUpperCase());
        return instanceInfo;
    }

    @Bean
    public DiscoveryClient hippo4JDiscoveryClient(HttpAgent httpAgent, InstanceInfo instanceInfo) {
        return new DiscoveryClient(httpAgent, instanceInfo);
    }

    public DiscoveryConfiguration(ConfigurableEnvironment environment, BootstrapProperties properties, InetUtils hippo4JInetUtils) {
        this.environment = environment;
        this.properties = properties;
        this.hippo4JInetUtils = hippo4JInetUtils;
    }
}

