/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedPolicies {
    private static final Logger log = LoggerFactory.getLogger(RejectedPolicies.class);

    public static RejectedExecutionHandler runsOldestTaskPolicy() {
        return (r, executor) -> {
            if (executor.isShutdown()) {
                return;
            }
            BlockingQueue<Runnable> workQueue = executor.getQueue();
            Runnable firstWork = (Runnable)workQueue.poll();
            boolean newTaskAdd = workQueue.offer(r);
            if (firstWork != null) {
                firstWork.run();
            }
            if (!newTaskAdd) {
                executor.execute(r);
            }
        };
    }

    public static RejectedExecutionHandler syncPutQueuePolicy() {
        return (r, executor) -> {
            if (executor.isShutdown()) {
                return;
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                log.error("Adding Queue task to thread pool failed.", (Throwable)e);
            }
        };
    }
}

