/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.remote;

import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ServerListManager {
    private static final Logger log = LoggerFactory.getLogger(ServerListManager.class);
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    private String serverAddrsStr;
    volatile List<String> serverUrls = new ArrayList<String>();
    private volatile String currentServerAddr;
    private Iterator<String> iterator;
    private final BootstrapProperties properties;

    public ServerListManager(BootstrapProperties dynamicThreadPoolProperties) {
        this.properties = dynamicThreadPoolProperties;
        this.serverAddrsStr = this.properties.getServerAddr();
        if (!StringUtils.isEmpty((Object)this.serverAddrsStr)) {
            String[] serverAddrListArr;
            ArrayList<String> serverAddrList = new ArrayList<String>();
            for (String serverAddr : serverAddrListArr = this.serverAddrsStr.split(",")) {
                boolean whetherJoint;
                boolean bl = whetherJoint = StrUtil.isNotBlank((CharSequence)serverAddr) && !serverAddr.startsWith(HTTPS) && !serverAddr.startsWith(HTTP);
                if (whetherJoint) {
                    serverAddr = HTTP + serverAddr;
                }
                this.currentServerAddr = serverAddr;
                serverAddrList.add(serverAddr);
            }
            this.serverUrls = serverAddrList;
        }
    }

    public String getCurrentServerAddr() {
        if (StringUtils.isEmpty((Object)this.currentServerAddr)) {
            this.iterator = this.iterator();
            this.currentServerAddr = this.iterator.next();
        }
        return this.currentServerAddr;
    }

    Iterator<String> iterator() {
        return new ServerAddressIterator(this.serverUrls);
    }

    public List<String> getServerUrls() {
        return this.serverUrls;
    }

    private static class ServerAddressIterator
    implements Iterator<String> {
        final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
        final Iterator<RandomizedServerAddress> iter;

        public ServerAddressIterator(List<String> source) {
            for (String address : source) {
                this.sorted.add(new RandomizedServerAddress(address));
            }
            Collections.sort(this.sorted);
            this.iter = this.sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }

        static class RandomizedServerAddress
        implements Comparable<RandomizedServerAddress> {
            static Random random = new Random();
            String serverIp;
            int priority = 0;
            int seed;

            public RandomizedServerAddress(String ip) {
                try {
                    this.serverIp = ip;
                    this.seed = random.nextInt(Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int compareTo(RandomizedServerAddress other) {
                if (this.priority != other.priority) {
                    return other.priority - this.priority;
                }
                return other.seed - this.seed;
            }
        }
    }
}

