/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.remote;

import cn.hippo4j.starter.core.ShutdownExecuteException;
import cn.hippo4j.starter.event.ApplicationCompleteEvent;
import cn.hippo4j.starter.remote.ServerHealthCheck;
import cn.hippo4j.starter.toolkit.thread.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public abstract class AbstractHealthCheck
implements ServerHealthCheck,
InitializingBean,
ApplicationListener<ApplicationCompleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(AbstractHealthCheck.class);
    private volatile boolean healthStatus = true;
    private volatile boolean clientShutdownHook = false;
    private boolean contextInitComplete = false;
    private final ReentrantLock healthMainLock = new ReentrantLock();
    private final Condition healthCondition = this.healthMainLock.newCondition();
    private final ScheduledThreadPoolExecutor healthCheckExecutor = new ScheduledThreadPoolExecutor((int)new Integer(1), ThreadFactoryBuilder.builder().daemon(true).prefix("client.scheduled.health.check").build());

    protected abstract boolean sendHealthCheck();

    public void healthCheck() {
        boolean healthCheckStatus = this.sendHealthCheck();
        if (healthCheckStatus) {
            if (Objects.equals(this.healthStatus, false)) {
                this.healthStatus = true;
                log.info("\ud83d\ude80 The client reconnects to the server successfully.");
                this.signalAllBizThread();
            }
        } else {
            this.healthStatus = false;
        }
    }

    @Override
    public boolean isHealthStatus() {
        while (this.contextInitComplete && !this.healthStatus && !this.clientShutdownHook) {
            this.healthMainLock.lock();
            try {
                this.healthCondition.await();
            }
            finally {
                this.healthMainLock.unlock();
            }
        }
        if (!this.healthStatus) {
            throw new ShutdownExecuteException();
        }
        return this.healthStatus;
    }

    @Override
    public void setHealthStatus(boolean healthStatus) {
        this.healthMainLock.lock();
        try {
            this.healthStatus = healthStatus;
            log.warn("The server health status setting is unavailable.");
        }
        finally {
            this.healthMainLock.unlock();
        }
    }

    private void signalAllBizThread() {
        this.healthMainLock.lock();
        try {
            this.healthCondition.signalAll();
        }
        finally {
            this.healthMainLock.unlock();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.clientShutdownHook = true;
            this.signalAllBizThread();
        }));
        this.healthCheckExecutor.scheduleWithFixedDelay(() -> this.healthCheck(), 0L, 5L, TimeUnit.SECONDS);
    }

    public void onApplicationEvent(ApplicationCompleteEvent event) {
        this.contextInitComplete = true;
    }
}

