/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler;

import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.starter.handler.AbstractThreadPoolRuntime;
import cn.hippo4j.starter.toolkit.ByteConvertUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.RuntimeInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolRunStateHandler.class);
    private static InetAddress INET_ADDRESS;

    @Override
    protected PoolRunStateInfo supplement(PoolRunStateInfo poolRunStateInfo) {
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        String memoryProportion = StrUtil.builder((CharSequence[])new CharSequence[]{"\u5df2\u5206\u914d: ", ByteConvertUtil.getPrintSize(runtimeInfo.getTotalMemory()), " / \u6700\u5927\u53ef\u7528: ", ByteConvertUtil.getPrintSize(runtimeInfo.getMaxMemory())}).toString();
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        poolRunStateInfo.setHost(INET_ADDRESS.getHostAddress());
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize(runtimeInfo.getFreeMemory()));
        return poolRunStateInfo;
    }

    static {
        try {
            INET_ADDRESS = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            log.error("Local IP acquisition failed.", (Throwable)ex);
        }
    }
}

