/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler;

import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.toolkit.CalculateUtil;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractThreadPoolRuntime {
    protected abstract PoolRunStateInfo supplement(PoolRunStateInfo var1);

    public PoolRunStateInfo getPoolRunState(String threadPoolId) {
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        ThreadPoolExecutor pool = executorService.getExecutor();
        int corePoolSize = pool.getCorePoolSize();
        int maximumPoolSize = pool.getMaximumPoolSize();
        int poolSize = pool.getPoolSize();
        int activeCount = pool.getActiveCount();
        int largestPoolSize = pool.getLargestPoolSize();
        long completedTaskCount = pool.getCompletedTaskCount();
        String currentLoad = CalculateUtil.divide(activeCount, maximumPoolSize) + "";
        String peakLoad = CalculateUtil.divide(largestPoolSize, maximumPoolSize) + "";
        BlockingQueue<Runnable> queue = pool.getQueue();
        int queueSize = queue.size();
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        PoolRunStateInfo stateInfo = new PoolRunStateInfo();
        stateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        stateInfo.setTpId(threadPoolId);
        stateInfo.setPoolSize(Integer.valueOf(poolSize));
        stateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        stateInfo.setActiveSize(Integer.valueOf(activeCount));
        stateInfo.setCurrentLoad(currentLoad);
        stateInfo.setPeakLoad(peakLoad);
        stateInfo.setQueueType(queueType);
        stateInfo.setQueueSize(Integer.valueOf(queueSize));
        stateInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        stateInfo.setQueueRemainingCapacity(Integer.valueOf(remainingCapacity));
        stateInfo.setLargestPoolSize(Integer.valueOf(largestPoolSize));
        stateInfo.setCompletedTaskCount(Long.valueOf(completedTaskCount));
        int rejectCount = pool instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)pool).getRejectCount() : -1;
        stateInfo.setRejectCount(Integer.valueOf(rejectCount));
        stateInfo.setClientLastRefreshTime(DateUtil.formatDateTime((Date)new Date()));
        stateInfo.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return this.supplement(stateInfo);
    }
}

