/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.event;

import cn.hippo4j.common.constant.Constants;
import cn.hippo4j.common.function.NoArgsConsumer;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import cn.hippo4j.starter.toolkit.thread.ThreadPoolBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorEventExecutor {
    private static final Logger log = LoggerFactory.getLogger(MonitorEventExecutor.class);
    private static final ExecutorService EVENT_EXECUTOR = ThreadPoolBuilder.builder().threadFactory("client.monitor.event.executor").corePoolSize(Constants.AVAILABLE_PROCESSORS).maxPoolNum(Constants.AVAILABLE_PROCESSORS).workQueue(QueueTypeEnum.LINKED_BLOCKING_QUEUE).capacity(4096).rejected(new ThreadPoolExecutor.AbortPolicy()).build();

    public static void publishEvent(NoArgsConsumer consumer) {
        try {
            EVENT_EXECUTOR.execute(() -> ((NoArgsConsumer)consumer).accept());
        }
        catch (RejectedExecutionException ex) {
            log.error("Monitoring thread pool run events exceeded load.");
        }
    }
}

