/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.starter.core.ClientWorker;
import cn.hippo4j.starter.core.ConfigService;
import cn.hippo4j.starter.core.Listener;
import cn.hippo4j.starter.event.ApplicationCompleteEvent;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.remote.ServerHealthCheck;
import java.util.Arrays;
import org.springframework.context.ApplicationListener;

public class ThreadPoolConfigService
implements ConfigService,
ApplicationListener<ApplicationCompleteEvent> {
    private final ClientWorker clientWorker;
    private final ServerHealthCheck serverHealthCheck;

    public ThreadPoolConfigService(HttpAgent httpAgent, String identification, ServerHealthCheck serverHealthCheck) {
        this.serverHealthCheck = serverHealthCheck;
        this.clientWorker = new ClientWorker(httpAgent, identification, serverHealthCheck);
    }

    @Override
    public void addListener(String tenantId, String itemId, String tpId, Listener listener) {
        this.clientWorker.addTenantListeners(tenantId, itemId, tpId, Arrays.asList(listener));
    }

    @Override
    public String getServerStatus() {
        if (this.serverHealthCheck.isHealthStatus()) {
            return "UP";
        }
        return "DOWN";
    }

    public void onApplicationEvent(ApplicationCompleteEvent event) {
        this.clientWorker.notifyApplicationComplete();
    }
}

