/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.starter.common.CommonDynamicThreadPool;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.DynamicExecutorConfigurationSupport;
import cn.hippo4j.starter.core.DynamicThreadPool;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.core.ThreadPoolDynamicRefresh;
import cn.hippo4j.starter.core.ThreadPoolOperation;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import cn.hippo4j.starter.toolkit.thread.RejectedTypeEnum;
import cn.hippo4j.starter.toolkit.thread.ThreadPoolBuilder;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.task.TaskDecorator;

public final class DynamicThreadPoolPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolPostProcessor.class);
    private final BootstrapProperties properties;
    private final HttpAgent httpAgent;
    private final ThreadPoolOperation threadPoolOperation;
    private final ExecutorService executorService = ThreadPoolBuilder.builder().corePoolSize(2).maxPoolNum(4).keepAliveTime(2000L).timeUnit(TimeUnit.MILLISECONDS).workQueue(QueueTypeEnum.ARRAY_BLOCKING_QUEUE).capacity(1024).allowCoreThreadTimeOut(true).threadFactory("client.dynamic.threadPool.change.config").rejected(new ThreadPoolExecutor.AbortPolicy()).build();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DynamicThreadPoolExecutor) {
            DynamicThreadPool dynamicThreadPool = (DynamicThreadPool)ApplicationContextHolder.findAnnotationOnBean((String)beanName, DynamicThreadPool.class);
            if (Objects.isNull(dynamicThreadPool)) {
                return bean;
            }
            DynamicThreadPoolExecutor dynamicExecutor = (DynamicThreadPoolExecutor)bean;
            DynamicThreadPoolWrapper wrap = new DynamicThreadPoolWrapper(dynamicExecutor.getThreadPoolId(), dynamicExecutor);
            ThreadPoolExecutor remoteExecutor = this.fillPoolAndRegister(wrap);
            this.subscribeConfig(wrap);
            return remoteExecutor;
        }
        if (bean instanceof DynamicThreadPoolWrapper) {
            DynamicThreadPoolWrapper wrap = (DynamicThreadPoolWrapper)bean;
            this.registerAndSubscribe(wrap);
        }
        return bean;
    }

    protected void registerAndSubscribe(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        this.fillPoolAndRegister(dynamicThreadPoolWrap);
        this.subscribeConfig(dynamicThreadPoolWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPoolExecutor fillPoolAndRegister(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        String tpId = dynamicThreadPoolWrap.getTpId();
        HashMap<String, String> queryStrMap = new HashMap<String, String>(3);
        queryStrMap.put("tpId", tpId);
        queryStrMap.put("itemId", this.properties.getItemId());
        queryStrMap.put("namespace", this.properties.getNamespace());
        boolean isSubscribe = false;
        ThreadPoolExecutor poolExecutor = null;
        PoolParameterInfo ppi = new PoolParameterInfo();
        try {
            String resultJsonStr;
            Result result = this.httpAgent.httpGetByConfig("/hippo4j/v1/cs/configs", null, queryStrMap, 5000L);
            if (result.isSuccess() && result.getData() != null && (ppi = (PoolParameterInfo)JSONUtil.parseObject((String)(resultJsonStr = JSONUtil.toJSONString((Object)result.getData())), PoolParameterInfo.class)) != null) {
                BlockingQueue workQueue = QueueTypeEnum.createBlockingQueue(ppi.getQueueType(), ppi.getCapacity());
                poolExecutor = ThreadPoolBuilder.builder().dynamicPool().workQueue(workQueue).threadFactory(tpId).poolThreadSize(ppi.getCoreSize(), ppi.getMaxSize()).keepAliveTime(ppi.getKeepAliveTime().intValue(), TimeUnit.SECONDS).rejected(RejectedTypeEnum.createPolicy(ppi.getRejectedType())).alarmConfig(ppi.getIsAlarm(), ppi.getCapacityAlarm(), ppi.getLivenessAlarm()).allowCoreThreadTimeOut(EnableEnum.getBool((Integer)ppi.getAllowCoreThreadTimeOut())).build();
                if (poolExecutor instanceof DynamicExecutorConfigurationSupport) {
                    TaskDecorator taskDecorator = ((DynamicThreadPoolExecutor)dynamicThreadPoolWrap.getExecutor()).getTaskDecorator();
                    ((DynamicThreadPoolExecutor)poolExecutor).setTaskDecorator(taskDecorator);
                }
                dynamicThreadPoolWrap.setExecutor(poolExecutor);
                isSubscribe = true;
            }
        }
        catch (Exception ex) {
            poolExecutor = dynamicThreadPoolWrap.getExecutor() != null ? dynamicThreadPoolWrap.getExecutor() : CommonDynamicThreadPool.getInstance(tpId);
            dynamicThreadPoolWrap.setExecutor(poolExecutor);
            log.error("Failed to initialize thread pool configuration. error message :: {}", (Object)ex.getMessage());
        }
        finally {
            if (Objects.isNull(dynamicThreadPoolWrap.getExecutor())) {
                dynamicThreadPoolWrap.setExecutor(CommonDynamicThreadPool.getInstance(tpId));
            }
            dynamicThreadPoolWrap.setSubscribeFlag(isSubscribe);
        }
        GlobalThreadPoolManage.register(dynamicThreadPoolWrap.getTpId(), (PoolParameter)ppi, dynamicThreadPoolWrap);
        return poolExecutor;
    }

    protected void subscribeConfig(DynamicThreadPoolWrapper dynamicThreadPoolWrap) {
        if (dynamicThreadPoolWrap.isSubscribeFlag()) {
            this.threadPoolOperation.subscribeConfig(dynamicThreadPoolWrap.getTpId(), this.executorService, config -> ThreadPoolDynamicRefresh.refreshDynamicPool(config));
        }
    }

    public DynamicThreadPoolPostProcessor(BootstrapProperties properties, HttpAgent httpAgent, ThreadPoolOperation threadPoolOperation) {
        this.properties = properties;
        this.httpAgent = httpAgent;
        this.threadPoolOperation = threadPoolOperation;
    }
}

