/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.starter.alarm.ThreadPoolAlarm;
import cn.hippo4j.starter.alarm.ThreadPoolAlarmManage;
import cn.hippo4j.starter.core.DynamicExecutorConfigurationSupport;
import cn.hippo4j.starter.event.MonitorEventExecutor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.springframework.core.task.TaskDecorator;

public class DynamicThreadPoolExecutor
extends DynamicExecutorConfigurationSupport {
    private final AtomicInteger rejectCount = new AtomicInteger();
    private final AtomicInteger ctl = new AtomicInteger(DynamicThreadPoolExecutor.ctlOf(-536870912, 0));
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private TaskDecorator taskDecorator;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private String threadPoolId;
    private final AccessControlContext acc;
    private volatile ThreadPoolAlarm threadPoolAlarm;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private static final RuntimePermission SHUTDOWN_PERM = new RuntimePermission("modifyThread");
    private static final boolean ONLY_ONE = true;
    private ConcurrentHashMap<String, Date> statisticsTime = new ConcurrentHashMap(16);

    public DynamicThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, boolean waitForTasksToCompleteOnShutdown, long awaitTerminationMillis, @NonNull BlockingQueue<Runnable> workQueue, @NonNull String threadPoolId, @NonNull ThreadFactory threadFactory, @NonNull ThreadPoolAlarm threadPoolAlarm, @NonNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, waitForTasksToCompleteOnShutdown, awaitTerminationMillis, workQueue, threadPoolId, threadFactory, handler);
        if (workQueue == null) {
            throw new NullPointerException("workQueue is marked non-null but is null");
        }
        if (threadPoolId == null) {
            throw new NullPointerException("threadPoolId is marked non-null but is null");
        }
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        if (threadPoolAlarm == null) {
            throw new NullPointerException("threadPoolAlarm is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.threadPoolId = threadPoolId;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
        this.threadPoolAlarm = threadPoolAlarm;
        this.acc = System.getSecurityManager() == null ? null : AccessController.getContext();
    }

    private static int runStateOf(int c) {
        return c & 0xE0000000;
    }

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    private static int ctlOf(int rs, int wc) {
        return rs | wc;
    }

    private static boolean runStateLessThan(int c, int s) {
        return c < s;
    }

    private static boolean runStateAtLeast(int c, int s) {
        return c >= s;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    private boolean compareAndIncrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect + 1);
    }

    private boolean compareAndDecrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect - 1);
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    public Integer getRejectCount() {
        return this.rejectCount.get();
    }

    public ThreadPoolAlarm getThreadPoolAlarm() {
        return this.threadPoolAlarm;
    }

    public void setThreadPoolAlarm(ThreadPoolAlarm threadPoolAlarm) {
        this.threadPoolAlarm = threadPoolAlarm;
    }

    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    private void advanceRunState(int targetState) {
        int c;
        while (!DynamicThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, DynamicThreadPoolExecutor.ctlOf(targetState, DynamicThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int c;
        while (!(DynamicThreadPoolExecutor.isRunning(c = this.ctl.get()) || DynamicThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || DynamicThreadPoolExecutor.runStateOf(c) == 0 && !this.workQueue.isEmpty())) {
            if (DynamicThreadPoolExecutor.workerCountOf(c) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (!this.ctl.compareAndSet(c, DynamicThreadPoolExecutor.ctlOf(0x40000000, 0))) continue;
                try {
                    this.terminated();
                }
                finally {
                    this.ctl.set(DynamicThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                }
                return;
            }
            finally {
                mainLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SHUTDOWN_PERM);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                for (Worker w : this.workers) {
                    security.checkAccess(w.thread);
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfStarted();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable command) {
        this.rejectCount.incrementAndGet();
        MonitorEventExecutor.publishEvent(() -> ThreadPoolAlarmManage.checkPoolRejectAlarm(this));
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean shutdownOk) {
        int rs = DynamicThreadPoolExecutor.runStateOf(this.ctl.get());
        return rs == -536870912 || rs == 0 && shutdownOk;
    }

    private List<Runnable> drainQueue() {
        BlockingQueue<Runnable> q = this.workQueue;
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        q.drainTo(taskList);
        if (!q.isEmpty()) {
            for (Runnable r : q.toArray(new Runnable[0])) {
                if (!q.remove(r)) continue;
                taskList.add(r);
            }
        }
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        boolean workerStarted;
        block15: {
            block6: while (true) {
                int c;
                int rs;
                if ((rs = DynamicThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs != 0 || firstTask != null || this.workQueue.isEmpty())) {
                    return false;
                }
                do {
                    int wc;
                    if ((wc = DynamicThreadPoolExecutor.workerCountOf(c)) >= 0x1FFFFFFF || wc >= (core ? this.corePoolSize : this.maximumPoolSize)) {
                        return false;
                    }
                    if (this.compareAndIncrementWorkerCount(c)) break block6;
                } while (DynamicThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
            }
            MonitorEventExecutor.publishEvent(() -> ThreadPoolAlarmManage.checkPoolLivenessAlarm(core, this));
            workerStarted = false;
            boolean workerAdded = false;
            Worker w = null;
            try {
                w = new Worker(firstTask);
                Thread t = w.thread;
                if (t == null) break block15;
                ReentrantLock mainLock = this.mainLock;
                mainLock.lock();
                try {
                    int rs = DynamicThreadPoolExecutor.runStateOf(this.ctl.get());
                    if (rs < 0 || rs == 0 && firstTask == null) {
                        if (t.isAlive()) {
                            throw new IllegalThreadStateException();
                        }
                        this.workers.add(w);
                        int s = this.workers.size();
                        if (s > this.largestPoolSize) {
                            this.largestPoolSize = s;
                        }
                        workerAdded = true;
                    }
                }
                finally {
                    mainLock.unlock();
                }
                if (workerAdded) {
                    t.start();
                    workerStarted = true;
                }
            }
            finally {
                if (!workerStarted) {
                    this.addWorkerFailed(w);
                }
            }
        }
        return workerStarted;
    }

    private void addWorkerFailed(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (w != null) {
                this.workers.remove(w);
            }
            this.decrementWorkerCount();
            this.tryTerminate();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (DynamicThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                int min;
                int n = min = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if (DynamicThreadPoolExecutor.workerCountOf(c) >= min) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean timedOut = false;
        while (true) {
            boolean timed;
            int c;
            int rs;
            if ((rs = DynamicThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs >= 0x20000000 || this.workQueue.isEmpty())) {
                this.decrementWorkerCount();
                return null;
            }
            int wc = DynamicThreadPoolExecutor.workerCountOf(c);
            boolean bl = timed = this.allowCoreThreadTimeOut || wc > this.corePoolSize;
            if ((wc > this.maximumPoolSize || timed && timedOut) && (wc > 1 || this.workQueue.isEmpty())) {
                if (!this.compareAndDecrementWorkerCount(c)) continue;
                return null;
            }
            try {
                Runnable r;
                Runnable runnable = r = timed ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take();
                if (r != null) {
                    return r;
                }
                timedOut = true;
                continue;
            }
            catch (InterruptedException retry) {
                timedOut = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker w) {
        Thread wt = Thread.currentThread();
        Runnable task = w.firstTask;
        w.firstTask = null;
        w.unlock();
        boolean completedAbruptly = true;
        try {
            while (task != null || (task = this.getTask()) != null) {
                w.lock();
                if ((DynamicThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000) || Thread.interrupted() && DynamicThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) && !wt.isInterrupted()) {
                    wt.interrupt();
                }
                try {
                    this.beforeExecute(wt, task);
                    Throwable thrown = null;
                    try {
                        task.run();
                    }
                    catch (RuntimeException x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Error x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Throwable x) {
                        thrown = x;
                        throw new Error(x);
                    }
                    finally {
                        this.afterExecute(task, thrown);
                    }
                }
                finally {
                    task = null;
                    ++w.completedTasks;
                    w.unlock();
                }
            }
            completedAbruptly = false;
        }
        finally {
            this.processWorkerExit(w, completedAbruptly);
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        int c;
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (this.taskDecorator != null) {
            command = this.taskDecorator.decorate(command);
        }
        if (DynamicThreadPoolExecutor.workerCountOf(c = this.ctl.get()) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (DynamicThreadPoolExecutor.isRunning(c) && this.workQueue.offer(command)) {
            MonitorEventExecutor.publishEvent(() -> ThreadPoolAlarmManage.checkPoolCapacityAlarm(this));
            int recheck = this.ctl.get();
            if (!DynamicThreadPoolExecutor.isRunning(recheck) && this.remove(command)) {
                this.reject(command);
            } else if (DynamicThreadPoolExecutor.workerCountOf(recheck) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(command, false)) {
            this.reject(command);
        }
    }

    @Override
    protected ExecutorService initializeExecutor() {
        return this;
    }

    @Override
    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            tasks = this.drainQueue();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return !DynamicThreadPoolExecutor.isRunning(this.ctl.get());
    }

    @Override
    public boolean isTerminating() {
        int c = this.ctl.get();
        return !DynamicThreadPoolExecutor.isRunning(c) && DynamicThreadPoolExecutor.runStateLessThan(c, 0x60000000);
    }

    @Override
    public boolean isTerminated() {
        return DynamicThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (DynamicThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    protected void finalize() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || this.acc == null) {
            this.shutdown();
        } else {
            PrivilegedAction<Void> pa = () -> {
                this.shutdown();
                return null;
            };
            AccessController.doPrivileged(pa, this.acc);
        }
    }

    @Override
    public void setThreadFactory(@NonNull ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
        this.threadFactory = threadFactory;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    @Override
    public void setRejectedExecutionHandler(@NonNull RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.handler = handler;
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        block3: {
            int delta;
            block2: {
                if (corePoolSize < 0) {
                    throw new IllegalArgumentException();
                }
                delta = corePoolSize - this.corePoolSize;
                this.corePoolSize = corePoolSize;
                if (DynamicThreadPoolExecutor.workerCountOf(this.ctl.get()) <= corePoolSize) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (delta <= 0) break block3;
            int k = Math.min(delta, this.workQueue.size());
            while (k-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    @Override
    public boolean prestartCoreThread() {
        return DynamicThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    public TaskDecorator getTaskDecorator() {
        return this.taskDecorator;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    void ensurePrestart() {
        int wc = DynamicThreadPoolExecutor.workerCountOf(this.ctl.get());
        if (wc < this.corePoolSize) {
            this.addWorker(null, true);
        } else if (wc == 0) {
            this.addWorker(null, false);
        }
    }

    @Override
    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (value != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = value;
            if (value) {
                this.interruptIdleWorkers();
            }
        }
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
        if (DynamicThreadPoolExecutor.workerCountOf(this.ctl.get()) > maximumPoolSize) {
            this.interruptIdleWorkers();
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long keepAliveTime = unit.toNanos(time);
        long delta = keepAliveTime - this.keepAliveTime;
        this.keepAliveTime = keepAliveTime;
        if (delta < 0L) {
            this.interruptIdleWorkers();
        }
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    @Override
    public boolean remove(Runnable task) {
        boolean removed = this.workQueue.remove(task);
        this.tryTerminate();
        return removed;
    }

    @Override
    public void purge() {
        BlockingQueue<Runnable> q = this.workQueue;
        try {
            Iterator it = q.iterator();
            while (it.hasNext()) {
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !((Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException fallThrough) {
            for (Object r : q.toArray()) {
                if (!(r instanceof Future) || !((Future)r).isCancelled()) continue;
                q.remove(r);
            }
        }
        this.tryTerminate();
    }

    @Override
    public int getPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = DynamicThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    @Override
    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
                if (!w.isLocked()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        int nworkers;
        int nactive;
        long ncompleted;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            ncompleted = this.completedTaskCount;
            nactive = 0;
            nworkers = this.workers.size();
            for (Worker w : this.workers) {
                ncompleted += w.completedTasks;
                if (!w.isLocked()) continue;
                ++nactive;
            }
        }
        finally {
            mainLock.unlock();
        }
        int c = this.ctl.get();
        String rs = DynamicThreadPoolExecutor.runStateLessThan(c, 0) ? "Running" : (DynamicThreadPoolExecutor.runStateAtLeast(c, 0x60000000) ? "Terminated" : "Shutting down");
        return super.toString() + "[" + rs + ", pool size = " + nworkers + ", active threads = " + nactive + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + ncompleted + "]";
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.statisticsTime.put(String.valueOf(r.hashCode()), new Date());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Date startDate = this.statisticsTime.remove(String.valueOf(r.hashCode()));
        Date finishDate = new Date();
    }

    @Override
    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.setState(-1);
            this.firstTask = firstTask;
            this.thread = DynamicThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        @Override
        public void run() {
            DynamicThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int unused) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int unused) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        public void lock() {
            this.acquire(1);
        }

        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        public void unlock() {
            this.release(1);
        }

        public boolean isLocked() {
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            Thread t;
            if (this.getState() >= 0 && (t = this.thread) != null && !t.isInterrupted()) {
                try {
                    t.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }
}

