/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class DynamicExecutorConfigurationSupport
extends ThreadPoolExecutor
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicExecutorConfigurationSupport.class);
    private String threadPoolId;
    private ExecutorService executor;
    private long awaitTerminationMillis = 0L;
    private boolean waitForTasksToCompleteOnShutdown = false;

    public DynamicExecutorConfigurationSupport(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, boolean waitForTasksToCompleteOnShutdown, long awaitTerminationMillis, BlockingQueue<Runnable> workQueue, String threadPoolId, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.threadPoolId = threadPoolId;
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
        this.awaitTerminationMillis = awaitTerminationMillis;
    }

    protected abstract ExecutorService initializeExecutor();

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void destroy() {
        this.shutdownSupport();
    }

    public void initialize() {
        if (log.isInfoEnabled()) {
            log.info("Initializing ExecutorService" + (this.threadPoolId != null ? " '" + this.threadPoolId + "'" : ""));
        }
        this.executor = this.initializeExecutor();
    }

    public void shutdownSupport() {
        if (log.isInfoEnabled()) {
            log.info("Shutting down ExecutorService" + (this.threadPoolId != null ? " '" + this.threadPoolId + "'" : ""));
        }
        if (this.executor != null) {
            if (this.waitForTasksToCompleteOnShutdown) {
                this.executor.shutdown();
            } else {
                for (Runnable remainingTask : this.executor.shutdownNow()) {
                    this.cancelRemainingTask(remainingTask);
                }
            }
            this.awaitTerminationIfNecessary(this.executor);
        }
    }

    protected void cancelRemainingTask(Runnable task) {
        if (task instanceof Future) {
            ((Future)((Object)task)).cancel(true);
        }
    }

    private void awaitTerminationIfNecessary(ExecutorService executor) {
        if (this.awaitTerminationMillis > 0L) {
            try {
                if (!executor.awaitTermination(this.awaitTerminationMillis, TimeUnit.MILLISECONDS) && log.isWarnEnabled()) {
                    log.warn("Timed out while waiting for executor" + (this.threadPoolId != null ? " '" + this.threadPoolId + "'" : "") + " to terminate.");
                }
            }
            catch (InterruptedException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Interrupted while waiting for executor" + (this.threadPoolId != null ? " '" + this.threadPoolId + "'" : "") + " to terminate.");
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

