/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.config;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.starter.alarm.AlarmControlHandler;
import cn.hippo4j.starter.alarm.BaseSendMessageService;
import cn.hippo4j.starter.alarm.SendMessageHandler;
import cn.hippo4j.starter.alarm.SendMessageService;
import cn.hippo4j.starter.alarm.ding.DingSendMessageHandler;
import cn.hippo4j.starter.alarm.lark.LarkSendMessageHandler;
import cn.hippo4j.starter.alarm.wechat.WeChatSendMessageHandler;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.remote.HttpAgent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;

public class MessageAlarmConfig {
    private final BootstrapProperties properties;
    private final InstanceInfo instanceInfo;
    private ConfigurableEnvironment environment;
    public static final String ACTIVE_DEFAULT = "unknown";
    public static final String SEND_MESSAGE_BEAN_NAME = "hippo4JSendMessageService";

    @DependsOn(value={"hippo4JApplicationContextHolder"})
    @Bean(value={"hippo4JSendMessageService"})
    public SendMessageService hippo4JSendMessageService(HttpAgent httpAgent, AlarmControlHandler alarmControlHandler) {
        return new BaseSendMessageService(httpAgent, this.properties, alarmControlHandler);
    }

    @Bean
    public SendMessageHandler dingSendMessageHandler() {
        String active = this.environment.getProperty("spring.profiles.active", ACTIVE_DEFAULT);
        return new DingSendMessageHandler(active, this.instanceInfo);
    }

    @Bean
    public SendMessageHandler larkSendMessageHandler() {
        String active = this.environment.getProperty("spring.profiles.active", ACTIVE_DEFAULT);
        return new LarkSendMessageHandler(active, this.instanceInfo);
    }

    @Bean
    public SendMessageHandler weChatSendMessageHandler() {
        String active = this.environment.getProperty("spring.profiles.active", ACTIVE_DEFAULT);
        return new WeChatSendMessageHandler(active, this.instanceInfo);
    }

    @Bean
    public AlarmControlHandler alarmControlHandler() {
        return new AlarmControlHandler();
    }

    public MessageAlarmConfig(BootstrapProperties properties, InstanceInfo instanceInfo, ConfigurableEnvironment environment) {
        this.properties = properties;
        this.instanceInfo = instanceInfo;
        this.environment = environment;
    }
}

