/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.alarm.lark;

import cn.hippo4j.common.enums.EnableEnum;
import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.starter.alarm.NotifyDTO;
import cn.hippo4j.starter.alarm.NotifyPlatformEnum;
import cn.hippo4j.starter.alarm.SendMessageHandler;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import cn.hippo4j.starter.toolkit.thread.RejectedTypeEnum;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class LarkSendMessageHandler
implements SendMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(LarkSendMessageHandler.class);
    private final String active;
    private final InstanceInfo instanceInfo;

    @Override
    public String getType() {
        return NotifyPlatformEnum.LARK.name();
    }

    @Override
    public void sendAlarmMessage(NotifyDTO notifyConfig, DynamicThreadPoolExecutor pool) {
        this.larkAlarmSendMessage(notifyConfig, pool);
    }

    @Override
    public void sendChangeMessage(NotifyDTO notifyConfig, PoolParameterInfo parameter) {
        this.larkChangeSendMessage(notifyConfig, parameter);
    }

    private void larkAlarmSendMessage(NotifyDTO notifyConfig, DynamicThreadPoolExecutor pool) {
        String afterReceives = this.getReceives(notifyConfig);
        BlockingQueue<Runnable> queue = pool.getQueue();
        String larkAlarmJson = this.getLarkJson("classpath:properties/lark/alarm.json");
        String text = String.format(larkAlarmJson, new Object[]{this.active.toUpperCase(), pool.getThreadPoolId(), this.instanceInfo.getAppName(), this.instanceInfo.getIdentify(), notifyConfig.getTypeEnum(), pool.getCorePoolSize(), pool.getMaximumPoolSize(), pool.getPoolSize(), pool.getActiveCount(), pool.getLargestPoolSize(), pool.getCompletedTaskCount(), queue.getClass().getSimpleName(), queue.size() + queue.remainingCapacity(), queue.size(), queue.remainingCapacity(), pool.getRejectedExecutionHandler().getClass().getSimpleName(), pool.getRejectCount(), afterReceives, DateUtil.now(), notifyConfig.getInterval()});
        this.execute(notifyConfig, text);
    }

    private void larkChangeSendMessage(NotifyDTO notifyConfig, PoolParameterInfo parameter) {
        String threadPoolId = parameter.getTpId();
        DynamicThreadPoolWrapper poolWrap = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        if (poolWrap == null) {
            log.warn("Thread pool is empty when sending change notification, threadPoolId :: {}", (Object)threadPoolId);
            return;
        }
        String afterReceives = this.getReceives(notifyConfig);
        ThreadPoolExecutor customPool = poolWrap.getExecutor();
        String larkNoticeJson = this.getLarkJson("classpath:properties/lark/notice.json");
        String text = String.format(larkNoticeJson, this.active.toUpperCase(), threadPoolId, this.instanceInfo.getAppName(), this.instanceInfo.getIdentify(), customPool.getCorePoolSize() + "  \u27b2  " + parameter.getCoreSize(), customPool.getMaximumPoolSize() + "  \u27b2  " + parameter.getMaxSize(), customPool.allowsCoreThreadTimeOut() + "  \u27b2  " + EnableEnum.getBool((Integer)parameter.getAllowCoreThreadTimeOut()), customPool.getKeepAliveTime(TimeUnit.SECONDS) + "  \u27b2  " + parameter.getKeepAliveTime(), QueueTypeEnum.getBlockingQueueNameByType(parameter.getQueueType()), customPool.getQueue().size() + customPool.getQueue().remainingCapacity() + "  \u27b2  " + parameter.getCapacity(), customPool.getRejectedExecutionHandler().getClass().getSimpleName(), RejectedTypeEnum.getRejectedNameByType(parameter.getRejectedType()), afterReceives, DateUtil.now());
        this.execute(notifyConfig, text);
    }

    private String getLarkJson(String filePath) throws FileNotFoundException {
        return FileUtil.readString((File)ResourceUtils.getFile((String)filePath), (Charset)StandardCharsets.UTF_8);
    }

    private String getReceives(NotifyDTO notifyConfig) {
        if (StringUtil.isBlank((CharSequence)notifyConfig.getReceives())) {
            return "";
        }
        return Arrays.stream(notifyConfig.getReceives().split(",")).map(receive -> StrUtil.startWith((CharSequence)receive, (CharSequence)"ou_") ? String.format("<at id='%s'></at>", receive) : String.format("<at id=''>%s</at>", receive)).collect(Collectors.joining(" "));
    }

    private void execute(NotifyDTO notifyConfig, String text) {
        String serverUrl = "https://open.feishu.cn/open-apis/bot/v2/hook/" + notifyConfig.getSecretKey();
        try {
            HttpRequest.post((String)serverUrl).body(text).execute();
        }
        catch (Exception ex) {
            log.error("Lark failed to send message", (Throwable)ex);
        }
    }

    public LarkSendMessageHandler(String active, InstanceInfo instanceInfo) {
        this.active = active;
        this.instanceInfo = instanceInfo;
    }
}

