/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit.thread;

import cn.hippo4j.starter.toolkit.thread.TaskQueue;
import cn.hippo4j.starter.toolkit.thread.ThreadPoolExecutorTemplate;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastThreadPoolExecutor
extends ThreadPoolExecutorTemplate {
    private static final Logger log = LoggerFactory.getLogger(FastThreadPoolExecutor.class);
    private final AtomicInteger submittedTaskCount = new AtomicInteger(0);

    public FastThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, TaskQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public int getSubmittedTaskCount() {
        return this.submittedTaskCount.get();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedTaskCount.decrementAndGet();
    }

    @Override
    public void execute(Runnable command) {
        this.submittedTaskCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            TaskQueue queue = (TaskQueue)super.getQueue();
            try {
                if (!queue.retryOffer(command, 0L, TimeUnit.MILLISECONDS)) {
                    this.submittedTaskCount.decrementAndGet();
                    throw new RejectedExecutionException("The blocking queue capacity is full.", rx);
                }
            }
            catch (InterruptedException x) {
                this.submittedTaskCount.decrementAndGet();
                throw new RejectedExecutionException(x);
            }
        }
        catch (Exception t) {
            this.submittedTaskCount.decrementAndGet();
            throw t;
        }
    }
}

