/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.config.DynamicThreadPoolAutoConfiguration;
import cn.hippo4j.starter.toolkit.inet.InetUtils;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.springframework.core.env.ConfigurableEnvironment;

public class IdentifyUtil {
    private static String identify;

    public static synchronized String generate(ConfigurableEnvironment environment, InetUtils hippo4JInetUtils) {
        String identification;
        if (StrUtil.isNotBlank((CharSequence)identify)) {
            return identify;
        }
        String ip = hippo4JInetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        String port = environment.getProperty("server.port");
        identify = identification = StrUtil.builder((CharSequence[])new CharSequence[]{ip, ":", port, "_", DynamicThreadPoolAutoConfiguration.CLIENT_IDENTIFICATION_VALUE}).toString();
        return identification;
    }

    public static String getIdentify() {
        while (StrUtil.isBlank((CharSequence)identify)) {
            ConfigurableEnvironment environment = (ConfigurableEnvironment)ApplicationContextHolder.getBean(ConfigurableEnvironment.class);
            InetUtils inetUtils = (InetUtils)ApplicationContextHolder.getBean(InetUtils.class);
            if (environment != null && inetUtils != null) {
                String identify = IdentifyUtil.generate(environment, inetUtils);
                return identify;
            }
            Thread.sleep(500L);
        }
        return identify;
    }

    public static String getThreadPoolIdentify(String threadPoolId, BootstrapProperties properties) {
        ArrayList params = Lists.newArrayList((Object[])new String[]{threadPoolId, properties.getItemId(), properties.getNamespace(), IdentifyUtil.getIdentify()});
        return Joiner.on((String)"+").join((Iterable)params);
    }
}

