/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.monitor.collect;

import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.common.monitor.Message;
import cn.hippo4j.common.monitor.MessageTypeEnum;
import cn.hippo4j.common.monitor.RuntimeMessage;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.handler.AbstractThreadPoolRuntime;
import cn.hippo4j.starter.monitor.collect.Collector;
import cn.hippo4j.starter.toolkit.IdentifyUtil;
import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class RunTimeInfoCollector
extends AbstractThreadPoolRuntime
implements Collector {
    private final BootstrapProperties properties;

    @Override
    public Message collectMessage() {
        RuntimeMessage message = new RuntimeMessage();
        ArrayList runtimeMessages = Lists.newArrayList();
        List<String> listThreadPoolId = GlobalThreadPoolManage.listThreadPoolId();
        for (String each : listThreadPoolId) {
            PoolRunStateInfo poolRunState = this.getPoolRunState(each);
            RuntimeMessage runtimeMessage = (RuntimeMessage)BeanUtil.toBean((Object)poolRunState, RuntimeMessage.class);
            runtimeMessage.setGroupKey(IdentifyUtil.getThreadPoolIdentify(each, this.properties));
            runtimeMessages.add(runtimeMessage);
        }
        message.setMessageType(MessageTypeEnum.RUNTIME);
        message.setMessages((List)runtimeMessages);
        return message;
    }

    @Override
    protected PoolRunStateInfo supplement(PoolRunStateInfo basePoolRunStateInfo) {
        return basePoolRunStateInfo;
    }

    public RunTimeInfoCollector(BootstrapProperties properties) {
        this.properties = properties;
    }
}

