/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalThreadPoolManage {
    private static final Map<String, PoolParameter> POOL_PARAMETER = new ConcurrentHashMap<String, PoolParameter>();
    private static final Map<String, DynamicThreadPoolWrapper> EXECUTOR_MAP = new ConcurrentHashMap<String, DynamicThreadPoolWrapper>();

    public static DynamicThreadPoolWrapper getExecutorService(String threadPoolId) {
        return EXECUTOR_MAP.get(threadPoolId);
    }

    public static PoolParameter getPoolParameter(String threadPoolId) {
        return POOL_PARAMETER.get(threadPoolId);
    }

    public static void register(String threadPoolId, PoolParameter poolParameter, DynamicThreadPoolWrapper executor) {
        GlobalThreadPoolManage.registerPool(threadPoolId, executor);
        GlobalThreadPoolManage.registerPoolParameter(threadPoolId, poolParameter);
    }

    public static void registerPool(String threadPoolId, DynamicThreadPoolWrapper executor) {
        EXECUTOR_MAP.put(threadPoolId, executor);
    }

    public static void registerPoolParameter(String threadPoolId, PoolParameter poolParameter) {
        POOL_PARAMETER.put(threadPoolId, poolParameter);
    }

    public static List<String> listThreadPoolId() {
        return Lists.newArrayList(POOL_PARAMETER.keySet());
    }

    public static Integer getThreadPoolNum() {
        return GlobalThreadPoolManage.listThreadPoolId().size();
    }
}

