/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.constant.Constants;
import cn.hippo4j.common.model.PoolParameter;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.common.toolkit.GroupKey;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.starter.core.CacheData;
import cn.hippo4j.starter.core.Listener;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.remote.ServerHealthCheck;
import cn.hippo4j.starter.toolkit.thread.ThreadFactoryBuilder;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ClientWorker {
    private static final Logger log = LoggerFactory.getLogger(ClientWorker.class);
    private long timeout;
    private double currentLongingTaskCount = 0.0;
    private final HttpAgent agent;
    private final String identification;
    private final ServerHealthCheck serverHealthCheck;
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService executorService;
    private final CountDownLatch awaitApplicationComplete = new CountDownLatch(1);
    private final ConcurrentHashMap<String, CacheData> cacheMap = new ConcurrentHashMap(16);

    public ClientWorker(HttpAgent httpAgent, String identification, ServerHealthCheck serverHealthCheck) {
        this.agent = httpAgent;
        this.identification = identification;
        this.timeout = 30000L;
        this.serverHealthCheck = serverHealthCheck;
        this.executor = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setName("client.worker.executor");
            t.setDaemon(true);
            return t;
        });
        this.executorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.builder().prefix("client.long.polling.executor").daemon(true).build());
        log.info("Client identity :: {}", (Object)identification);
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.awaitApplicationComplete.await();
                this.checkConfigInfo();
            }
            catch (Throwable e) {
                log.error("Sub check rotate check error.", e);
            }
        }, 1L, 1024L, TimeUnit.MILLISECONDS);
    }

    public void checkConfigInfo() {
        double perTaskConfigSize;
        int listenerSize = this.cacheMap.size();
        int longingTaskCount = (int)Math.ceil((double)listenerSize / (perTaskConfigSize = 3000.0));
        if ((double)longingTaskCount > this.currentLongingTaskCount) {
            for (int i = (int)this.currentLongingTaskCount; i < longingTaskCount; ++i) {
                this.executorService.execute(new LongPollingRunnable());
            }
            this.currentLongingTaskCount = longingTaskCount;
        }
    }

    private List<String> checkUpdateDataIds(List<CacheData> cacheDataList, List<String> inInitializingCacheList) {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDataList) {
            sb.append(cacheData.tpId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.itemId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.tenantId).append(Constants.WORD_SEPARATOR);
            sb.append(this.identification).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant((String)cacheData.tpId, (String)cacheData.itemId, (String)cacheData.tenantId));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateTpIds(sb.toString(), isInitializingCacheList);
    }

    public List<String> checkUpdateTpIds(String probeUpdateString, boolean isInitializingCacheList) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("Listening-Configs", probeUpdateString);
        params.put("Weight-Configs", IdUtil.simpleUUID());
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Long-Pulling-Timeout", "" + this.timeout);
        headers.put("Long-Pulling-Client-Identification", this.identification);
        if (isInitializingCacheList) {
            headers.put("Long-Pulling-Timeout-No-Hangup", "true");
        }
        if (StringUtils.isEmpty((Object)probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            long readTimeoutMs = this.timeout + (long)Math.round(this.timeout >> 1);
            Result result = this.agent.httpPostByConfig("/hippo4j/v1/cs/configs/listener", headers, params, readTimeoutMs);
            if (result != null && result.isSuccess()) {
                return this.parseUpdateDataIdResponse(result.getData().toString());
            }
        }
        catch (Exception ex) {
            this.setHealthServer(false);
            log.error("Check update get changed dataId exception. error message :: {}", (Object)ex.getMessage());
        }
        return Collections.emptyList();
    }

    public String getServerConfig(String namespace, String itemId, String tpId, long readTimeout) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("namespace", namespace);
        params.put("itemId", itemId);
        params.put("tpId", tpId);
        params.put("instanceId", this.identification);
        Result result = this.agent.httpGetByConfig("/hippo4j/v1/cs/configs", null, params, readTimeout);
        if (result.isSuccess()) {
            return JSONUtil.toJSONString((Object)result.getData());
        }
        log.error("Sub server namespace :: {}, itemId :: {}, tpId :: {}, result code :: {}", new Object[]{namespace, itemId, tpId, result.getCode()});
        return "";
    }

    public List<String> parseUpdateDataIdResponse(String response) {
        if (StringUtils.isEmpty((Object)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            log.error("Polling resp decode modifiedDataIdsString error.", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            if (StringUtils.isEmpty((Object)dataIdAndGroup)) continue;
            String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
            String dataId = keyArr[0];
            String group = keyArr[1];
            if (keyArr.length == 3) {
                String tenant = keyArr[2];
                updateList.add(GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant));
                log.info("Refresh thread pool changed. [{}]", (Object)dataId);
                continue;
            }
            log.error("[{}] Polling resp invalid dataIdAndGroup error.", (Object)dataIdAndGroup);
        }
        return updateList;
    }

    public void addTenantListeners(String namespace, String itemId, String tpId, List<? extends Listener> listeners) {
        CacheData cacheData = this.addCacheDataIfAbsent(namespace, itemId, tpId);
        for (Listener listener : listeners) {
            cacheData.addListener(listener);
        }
    }

    public CacheData addCacheDataIfAbsent(String namespace, String itemId, String tpId) {
        CacheData cacheData = this.cacheMap.get(tpId);
        if (cacheData != null) {
            return cacheData;
        }
        cacheData = new CacheData(namespace, itemId, tpId);
        CacheData lastCacheData = this.cacheMap.putIfAbsent(tpId, cacheData);
        if (lastCacheData == null) {
            try {
                String serverConfig = this.getServerConfig(namespace, itemId, tpId, 3000L);
                PoolParameterInfo poolInfo = (PoolParameterInfo)JSONUtil.parseObject((String)serverConfig, PoolParameterInfo.class);
                cacheData.setContent(ContentUtil.getPoolContent((PoolParameter)poolInfo));
            }
            catch (Exception ex) {
                log.error("Cache Data Error. Service Unavailable :: {}", (Object)ex.getMessage());
            }
            int taskId = this.cacheMap.size() / 30000;
            cacheData.setTaskId(taskId);
            lastCacheData = cacheData;
        }
        return lastCacheData;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.serverHealthCheck.setHealthStatus(isHealthServer);
    }

    protected void notifyApplicationComplete() {
        this.awaitApplicationComplete.countDown();
    }

    class LongPollingRunnable
    implements Runnable {
        LongPollingRunnable() {
        }

        @Override
        public void run() {
            ClientWorker.this.serverHealthCheck.isHealthStatus();
            ArrayList cacheDataList = new ArrayList();
            ArrayList inInitializingCacheList = new ArrayList();
            ClientWorker.this.cacheMap.forEach((key, val) -> cacheDataList.add(val));
            List changedTpIds = ClientWorker.this.checkUpdateDataIds(cacheDataList, inInitializingCacheList);
            for (String each : changedTpIds) {
                String[] keys = StrUtil.split((CharSequence)each, (CharSequence)"+");
                String tpId = keys[0];
                String itemId = keys[1];
                String namespace = keys[2];
                try {
                    String content = ClientWorker.this.getServerConfig(namespace, itemId, tpId, 3000L);
                    CacheData cacheData = (CacheData)ClientWorker.this.cacheMap.get(tpId);
                    String poolContent = ContentUtil.getPoolContent((PoolParameter)((PoolParameter)JSONUtil.parseObject((String)content, PoolParameterInfo.class)));
                    cacheData.setContent(poolContent);
                }
                catch (Exception ex) {
                    log.error("Failed to get the latest thread pool configuration.", (Throwable)ex);
                }
            }
            for (CacheData cacheData : cacheDataList) {
                if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant((String)cacheData.tpId, (String)cacheData.itemId, (String)cacheData.tenantId))) continue;
                cacheData.checkListenerMd5();
                cacheData.setInitializing(false);
            }
            inInitializingCacheList.clear();
            ClientWorker.this.executorService.execute(this);
        }
    }
}

