/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.alarm;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.common.toolkit.GroupKey;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.starter.alarm.AlarmControlDTO;
import cn.hippo4j.starter.alarm.AlarmControlHandler;
import cn.hippo4j.starter.alarm.MessageTypeEnum;
import cn.hippo4j.starter.alarm.NotifyDTO;
import cn.hippo4j.starter.alarm.SendMessageHandler;
import cn.hippo4j.starter.alarm.SendMessageService;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class BaseSendMessageService
implements InitializingBean,
SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(BaseSendMessageService.class);
    @NonNull
    private final HttpAgent httpAgent;
    @NonNull
    private final BootstrapProperties properties;
    @NonNull
    private final AlarmControlHandler alarmControlHandler;
    public static final Map<String, List<NotifyDTO>> ALARM_NOTIFY_CONFIG = Maps.newHashMap();
    private final Map<String, SendMessageHandler> sendMessageHandlers = Maps.newHashMap();

    @Override
    public void sendAlarmMessage(MessageTypeEnum typeEnum, DynamicThreadPoolExecutor executor) {
        String threadPoolId = executor.getThreadPoolId();
        String buildKey = StrUtil.builder((CharSequence[])new CharSequence[]{executor.getThreadPoolId(), "+", "ALARM"}).toString();
        List<NotifyDTO> notifyList = ALARM_NOTIFY_CONFIG.get(buildKey);
        if (CollUtil.isEmpty(notifyList)) {
            log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
                    return;
                }
                if (this.isSendAlarm(each.getTpId(), each.setTypeEnum(typeEnum))) {
                    messageHandler.sendAlarmMessage((NotifyDTO)each, executor);
                }
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool alarm notification. key :: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    @Override
    public void sendChangeMessage(PoolParameterInfo parameter) {
        String threadPoolId = parameter.getTpId();
        String buildKey = StrUtil.builder((CharSequence[])new CharSequence[]{parameter.getTpId(), "+", "CONFIG"}).toString();
        List<NotifyDTO> notifyList = ALARM_NOTIFY_CONFIG.get(buildKey);
        if (CollUtil.isEmpty(notifyList)) {
            log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key :: [{}]", (Object)threadPoolId);
                    return;
                }
                messageHandler.sendChangeMessage((NotifyDTO)each, parameter);
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool change notification. key :: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    public void afterPropertiesSet() {
        Map sendMessageHandlerMap = ApplicationContextHolder.getBeansOfType(SendMessageHandler.class);
        sendMessageHandlerMap.values().forEach(each -> this.sendMessageHandlers.put(each.getType(), (SendMessageHandler)each));
        List<String> threadPoolIds = GlobalThreadPoolManage.listThreadPoolId();
        if (CollUtil.isEmpty(threadPoolIds)) {
            log.warn("The client does not have a dynamic thread pool instance configured.");
            return;
        }
        ArrayList groupKeys = Lists.newArrayList();
        threadPoolIds.forEach(each -> {
            String groupKey = GroupKey.getKeyTenant((String)each, (String)this.properties.getItemId(), (String)this.properties.getNamespace());
            groupKeys.add(groupKey);
        });
        Result result = null;
        try {
            result = this.httpAgent.httpPostByDiscovery("/hippo4j/v1/cs/notify/list/config", new ThreadPoolNotifyReqDTO(groupKeys));
        }
        catch (Throwable ex) {
            log.error("Get dynamic thread pool notify configuration error. message :: {}", (Object)ex.getMessage());
        }
        if (result != null && result.isSuccess() && result.getData() != null) {
            String resultDataStr = JSONUtil.toJSONString((Object)result.getData());
            List resultData = JSONUtil.parseArray((String)resultDataStr, ThreadPoolNotify.class);
            resultData.forEach(each -> ALARM_NOTIFY_CONFIG.put(each.getNotifyKey(), each.getNotifyList()));
            ALARM_NOTIFY_CONFIG.forEach((key, val) -> val.stream().filter(each -> StrUtil.equals((CharSequence)"ALARM", (CharSequence)each.getType())).forEach(each -> {
                Cache cache = CacheBuilder.newBuilder().expireAfterWrite((long)each.getInterval().intValue(), TimeUnit.MINUTES).build();
                AlarmControlHandler.THREAD_POOL_ALARM_CACHE.put(StrUtil.builder((CharSequence[])new CharSequence[]{each.getTpId(), "+", each.getPlatform()}).toString(), (Cache<String, String>)cache);
            }));
        }
    }

    private boolean isSendAlarm(String threadPoolId, NotifyDTO notifyInfo) {
        AlarmControlDTO alarmControl = AlarmControlDTO.builder().threadPool(threadPoolId).platform(notifyInfo.getPlatform()).typeEnum(notifyInfo.getTypeEnum()).build();
        return this.alarmControlHandler.isSendAlarm(alarmControl);
    }

    public BaseSendMessageService(@NonNull HttpAgent httpAgent, @NonNull BootstrapProperties properties, @NonNull AlarmControlHandler alarmControlHandler) {
        if (httpAgent == null) {
            throw new NullPointerException("httpAgent is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (alarmControlHandler == null) {
            throw new NullPointerException("alarmControlHandler is marked non-null but is null");
        }
        this.httpAgent = httpAgent;
        this.properties = properties;
        this.alarmControlHandler = alarmControlHandler;
    }

    static class ThreadPoolNotify {
        private String notifyKey;
        private List<NotifyDTO> notifyList;

        public String getNotifyKey() {
            return this.notifyKey;
        }

        public List<NotifyDTO> getNotifyList() {
            return this.notifyList;
        }

        public void setNotifyKey(String notifyKey) {
            this.notifyKey = notifyKey;
        }

        public void setNotifyList(List<NotifyDTO> notifyList) {
            this.notifyList = notifyList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolNotify)) {
                return false;
            }
            ThreadPoolNotify other = (ThreadPoolNotify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$notifyKey = this.getNotifyKey();
            String other$notifyKey = other.getNotifyKey();
            if (this$notifyKey == null ? other$notifyKey != null : !this$notifyKey.equals(other$notifyKey)) {
                return false;
            }
            List<NotifyDTO> this$notifyList = this.getNotifyList();
            List<NotifyDTO> other$notifyList = other.getNotifyList();
            return !(this$notifyList == null ? other$notifyList != null : !((Object)this$notifyList).equals(other$notifyList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolNotify;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $notifyKey = this.getNotifyKey();
            result = result * 59 + ($notifyKey == null ? 43 : $notifyKey.hashCode());
            List<NotifyDTO> $notifyList = this.getNotifyList();
            result = result * 59 + ($notifyList == null ? 43 : ((Object)$notifyList).hashCode());
            return result;
        }

        public String toString() {
            return "BaseSendMessageService.ThreadPoolNotify(notifyKey=" + this.getNotifyKey() + ", notifyList=" + this.getNotifyList() + ")";
        }
    }

    static class ThreadPoolNotifyReqDTO {
        private List<String> groupKeys;

        public List<String> getGroupKeys() {
            return this.groupKeys;
        }

        public void setGroupKeys(List<String> groupKeys) {
            this.groupKeys = groupKeys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolNotifyReqDTO)) {
                return false;
            }
            ThreadPoolNotifyReqDTO other = (ThreadPoolNotifyReqDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$groupKeys = this.getGroupKeys();
            List<String> other$groupKeys = other.getGroupKeys();
            return !(this$groupKeys == null ? other$groupKeys != null : !((Object)this$groupKeys).equals(other$groupKeys));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolNotifyReqDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $groupKeys = this.getGroupKeys();
            result = result * 59 + ($groupKeys == null ? 43 : ((Object)$groupKeys).hashCode());
            return result;
        }

        public String toString() {
            return "BaseSendMessageService.ThreadPoolNotifyReqDTO(groupKeys=" + this.getGroupKeys() + ")";
        }

        public ThreadPoolNotifyReqDTO(List<String> groupKeys) {
            this.groupKeys = groupKeys;
        }
    }
}

