/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit.thread;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.starter.alarm.ThreadPoolAlarm;
import cn.hippo4j.starter.toolkit.thread.AbstractBuildThreadPoolTemplate;
import cn.hippo4j.starter.toolkit.thread.Builder;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolBuilder
implements Builder<ThreadPoolExecutor> {
    private boolean isFastPool;
    private boolean isDynamicPool;
    private int corePoolSize = this.calculateCoreNum();
    private int maxPoolSize = this.corePoolSize + (this.corePoolSize >> 1);
    private long keepAliveTime = 30000L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private int capacity = 512;
    private QueueTypeEnum queueType;
    private BlockingQueue workQueue = new LinkedBlockingQueue(this.capacity);
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
    private boolean isDaemon = false;
    private String threadNamePrefix;
    private String threadPoolId;
    private boolean isAlarm = false;
    private Integer capacityAlarm;
    private Integer livenessAlarm;

    private Integer calculateCoreNum() {
        int cpuCoreNum = Runtime.getRuntime().availableProcessors();
        return new BigDecimal(cpuCoreNum).divide(new BigDecimal("0.2")).intValue();
    }

    public ThreadPoolBuilder isFastPool(Boolean isFastPool) {
        this.isFastPool = isFastPool;
        return this;
    }

    public ThreadPoolBuilder dynamicPool() {
        this.isDynamicPool = true;
        return this;
    }

    public ThreadPoolBuilder threadFactory(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        return this;
    }

    public ThreadPoolBuilder threadFactory(String threadNamePrefix, Boolean isDaemon) {
        this.threadNamePrefix = threadNamePrefix;
        this.isDaemon = isDaemon;
        return this;
    }

    public ThreadPoolBuilder corePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
        return this;
    }

    public ThreadPoolBuilder maxPoolNum(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public ThreadPoolBuilder poolThreadSize(int corePoolSize, int maxPoolSize) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.keepAliveTime = keepAliveTime;
        this.timeUnit = timeUnit;
        return this;
    }

    public ThreadPoolBuilder capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public ThreadPoolBuilder workQueue(QueueTypeEnum queueType, int capacity) {
        this.queueType = queueType;
        this.capacity = capacity;
        return this;
    }

    public ThreadPoolBuilder rejected(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        return this;
    }

    public ThreadPoolBuilder workQueue(QueueTypeEnum queueType) {
        this.queueType = queueType;
        return this;
    }

    public ThreadPoolBuilder workQueue(BlockingQueue workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public ThreadPoolBuilder threadPoolId(String threadPoolId) {
        this.threadPoolId = threadPoolId;
        return this;
    }

    public ThreadPoolBuilder alarmConfig(int isAlarm, int capacityAlarm, int livenessAlarm) {
        this.isAlarm = isAlarm == 0;
        this.capacityAlarm = capacityAlarm;
        this.livenessAlarm = livenessAlarm;
        return this;
    }

    @Override
    public ThreadPoolExecutor build() {
        if (this.isDynamicPool) {
            return ThreadPoolBuilder.buildDynamicPool(this);
        }
        return this.isFastPool ? ThreadPoolBuilder.buildFastPool(this) : ThreadPoolBuilder.buildPool(this);
    }

    public static ThreadPoolBuilder builder() {
        return new ThreadPoolBuilder();
    }

    private static ThreadPoolExecutor buildPool(ThreadPoolBuilder builder) {
        return AbstractBuildThreadPoolTemplate.buildPool(ThreadPoolBuilder.buildInitParam(builder));
    }

    private static ThreadPoolExecutor buildFastPool(ThreadPoolBuilder builder) {
        return AbstractBuildThreadPoolTemplate.buildFastPool(ThreadPoolBuilder.buildInitParam(builder));
    }

    private static ThreadPoolExecutor buildDynamicPool(ThreadPoolBuilder builder) {
        return AbstractBuildThreadPoolTemplate.buildDynamicPool(ThreadPoolBuilder.buildInitParam(builder));
    }

    private static AbstractBuildThreadPoolTemplate.ThreadPoolInitParam buildInitParam(ThreadPoolBuilder builder) {
        Assert.notEmpty((String)builder.threadNamePrefix, (String)"The thread name prefix cannot be empty or an empty string.");
        AbstractBuildThreadPoolTemplate.ThreadPoolInitParam initParam = new AbstractBuildThreadPoolTemplate.ThreadPoolInitParam(builder.threadNamePrefix, builder.isDaemon);
        initParam.setCorePoolNum(builder.corePoolSize).setMaxPoolNum(builder.maxPoolSize).setKeepAliveTime(builder.keepAliveTime).setCapacity(builder.capacity).setRejectedExecutionHandler(builder.rejectedExecutionHandler).setTimeUnit(builder.timeUnit);
        if (builder.isDynamicPool) {
            String threadPoolId = Optional.ofNullable(builder.threadPoolId).orElse(builder.threadNamePrefix);
            initParam.setThreadPoolId(threadPoolId);
            ThreadPoolAlarm threadPoolAlarm = new ThreadPoolAlarm(builder.isAlarm, builder.capacityAlarm, builder.livenessAlarm);
            initParam.setThreadPoolAlarm(threadPoolAlarm);
        }
        if (!builder.isFastPool) {
            if (builder.queueType != null) {
                builder.workQueue = QueueTypeEnum.createBlockingQueue(builder.queueType.type, builder.capacity);
            }
            initParam.setWorkQueue(builder.workQueue);
        }
        return initParam;
    }
}

