/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit.thread;

import cn.hippo4j.starter.spi.CustomRejectedExecutionHandler;
import cn.hippo4j.starter.spi.DynamicTpServiceLoader;
import cn.hippo4j.starter.toolkit.thread.RejectedPolicies;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;

public enum RejectedTypeEnum {
    CALLER_RUNS_POLICY(1, new ThreadPoolExecutor.CallerRunsPolicy()),
    ABORT_POLICY(2, new ThreadPoolExecutor.AbortPolicy()),
    DISCARD_POLICY(3, new ThreadPoolExecutor.DiscardPolicy()),
    DISCARD_OLDEST_POLICY(4, new ThreadPoolExecutor.DiscardOldestPolicy()),
    RUNS_OLDEST_TASK_POLICY(5, RejectedPolicies.runsOldestTaskPolicy()),
    SYNC_PUT_QUEUE_POLICY(6, RejectedPolicies.syncPutQueuePolicy());

    public Integer type;
    public RejectedExecutionHandler rejectedHandler;

    private RejectedTypeEnum(Integer type, RejectedExecutionHandler rejectedHandler) {
        this.type = type;
        this.rejectedHandler = rejectedHandler;
    }

    public static RejectedExecutionHandler createPolicy(int type) {
        Optional<RejectedExecutionHandler> rejectedTypeEnum = Stream.of(RejectedTypeEnum.values()).filter(each -> Objects.equals(type, each.type)).map(each -> each.rejectedHandler).findFirst();
        RejectedExecutionHandler resultRejected = rejectedTypeEnum.orElseGet(() -> {
            Collection<CustomRejectedExecutionHandler> customRejectedExecutionHandlers = DynamicTpServiceLoader.getSingletonServiceInstances(CustomRejectedExecutionHandler.class);
            Optional<RejectedExecutionHandler> customRejected = customRejectedExecutionHandlers.stream().filter(each -> Objects.equals(type, each.getType())).map(each -> each.generateRejected()).findFirst();
            return customRejected.orElse(RejectedTypeEnum.ABORT_POLICY.rejectedHandler);
        });
        return resultRejected;
    }

    public static String getRejectedNameByType(int type) {
        Optional<RejectedTypeEnum> rejectedTypeEnum = Arrays.stream(RejectedTypeEnum.values()).filter(each -> each.type == type).findFirst();
        return rejectedTypeEnum.map(each -> each.rejectedHandler.getClass().getSimpleName()).orElse("");
    }

    static {
        DynamicTpServiceLoader.register(CustomRejectedExecutionHandler.class);
    }
}

