/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit.thread;

import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.starter.alarm.ThreadPoolAlarm;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.toolkit.thread.FastThreadPoolExecutor;
import cn.hippo4j.starter.toolkit.thread.TaskQueue;
import cn.hippo4j.starter.toolkit.thread.ThreadFactoryBuilder;
import cn.hippo4j.starter.toolkit.thread.ThreadPoolExecutorTemplate;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBuildThreadPoolTemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractBuildThreadPoolTemplate.class);

    protected static ThreadPoolInitParam initParam() {
        throw new UnsupportedOperationException();
    }

    public static ThreadPoolExecutor buildPool() {
        ThreadPoolInitParam initParam = AbstractBuildThreadPoolTemplate.initParam();
        return AbstractBuildThreadPoolTemplate.buildPool(initParam);
    }

    public static ThreadPoolExecutor buildPool(ThreadPoolInitParam initParam) {
        Assert.notNull((Object)initParam);
        ThreadPoolExecutorTemplate executorService = new ThreadPoolExecutorTemplate(initParam.getCorePoolNum(), initParam.getMaxPoolNum(), initParam.getKeepAliveTime(), initParam.getTimeUnit(), initParam.getWorkQueue(), initParam.getThreadFactory(), initParam.rejectedExecutionHandler);
        return executorService;
    }

    public static ThreadPoolExecutor buildFastPool() {
        ThreadPoolInitParam initParam = AbstractBuildThreadPoolTemplate.initParam();
        return AbstractBuildThreadPoolTemplate.buildFastPool(initParam);
    }

    public static ThreadPoolExecutor buildFastPool(ThreadPoolInitParam initParam) {
        TaskQueue<Runnable> taskQueue = new TaskQueue<Runnable>(initParam.getCapacity());
        FastThreadPoolExecutor fastThreadPoolExecutor = new FastThreadPoolExecutor((int)initParam.getCorePoolNum(), (int)initParam.getMaxPoolNum(), (long)initParam.getKeepAliveTime(), initParam.getTimeUnit(), taskQueue, initParam.getThreadFactory(), initParam.rejectedExecutionHandler);
        taskQueue.setExecutor(fastThreadPoolExecutor);
        return fastThreadPoolExecutor;
    }

    public static DynamicThreadPoolExecutor buildDynamicPool(ThreadPoolInitParam initParam) {
        Assert.notNull((Object)initParam);
        DynamicThreadPoolExecutor executorService = new DynamicThreadPoolExecutor(initParam.getCorePoolNum(), initParam.getMaxPoolNum(), initParam.getKeepAliveTime(), initParam.getTimeUnit(), initParam.getWorkQueue(), initParam.getThreadPoolId(), initParam.getThreadFactory(), initParam.getThreadPoolAlarm(), initParam.getRejectedExecutionHandler());
        return executorService;
    }

    public static class ThreadPoolInitParam {
        private Integer corePoolNum;
        private Integer maxPoolNum;
        private Long keepAliveTime;
        private TimeUnit timeUnit;
        private Integer capacity;
        private BlockingQueue<Runnable> workQueue;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private ThreadFactory threadFactory;
        private String threadPoolId;
        private ThreadPoolAlarm threadPoolAlarm;

        public ThreadPoolInitParam(String threadNamePrefix, boolean isDaemon) {
            this.threadPoolId = threadNamePrefix;
            this.threadFactory = ThreadFactoryBuilder.builder().prefix(threadNamePrefix).daemon(isDaemon).build();
        }

        public Integer getCorePoolNum() {
            return this.corePoolNum;
        }

        public Integer getMaxPoolNum() {
            return this.maxPoolNum;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Integer getCapacity() {
            return this.capacity;
        }

        public BlockingQueue<Runnable> getWorkQueue() {
            return this.workQueue;
        }

        public RejectedExecutionHandler getRejectedExecutionHandler() {
            return this.rejectedExecutionHandler;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public String getThreadPoolId() {
            return this.threadPoolId;
        }

        public ThreadPoolAlarm getThreadPoolAlarm() {
            return this.threadPoolAlarm;
        }

        public ThreadPoolInitParam setCorePoolNum(Integer corePoolNum) {
            this.corePoolNum = corePoolNum;
            return this;
        }

        public ThreadPoolInitParam setMaxPoolNum(Integer maxPoolNum) {
            this.maxPoolNum = maxPoolNum;
            return this;
        }

        public ThreadPoolInitParam setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public ThreadPoolInitParam setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public ThreadPoolInitParam setCapacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public ThreadPoolInitParam setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public ThreadPoolInitParam setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public ThreadPoolInitParam setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadPoolInitParam setThreadPoolId(String threadPoolId) {
            this.threadPoolId = threadPoolId;
            return this;
        }

        public ThreadPoolInitParam setThreadPoolAlarm(ThreadPoolAlarm threadPoolAlarm) {
            this.threadPoolAlarm = threadPoolAlarm;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolInitParam)) {
                return false;
            }
            ThreadPoolInitParam other = (ThreadPoolInitParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$corePoolNum = this.getCorePoolNum();
            Integer other$corePoolNum = other.getCorePoolNum();
            if (this$corePoolNum == null ? other$corePoolNum != null : !((Object)this$corePoolNum).equals(other$corePoolNum)) {
                return false;
            }
            Integer this$maxPoolNum = this.getMaxPoolNum();
            Integer other$maxPoolNum = other.getMaxPoolNum();
            if (this$maxPoolNum == null ? other$maxPoolNum != null : !((Object)this$maxPoolNum).equals(other$maxPoolNum)) {
                return false;
            }
            Long this$keepAliveTime = this.getKeepAliveTime();
            Long other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            TimeUnit this$timeUnit = this.getTimeUnit();
            TimeUnit other$timeUnit = other.getTimeUnit();
            if (this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit)) {
                return false;
            }
            Integer this$capacity = this.getCapacity();
            Integer other$capacity = other.getCapacity();
            if (this$capacity == null ? other$capacity != null : !((Object)this$capacity).equals(other$capacity)) {
                return false;
            }
            BlockingQueue<Runnable> this$workQueue = this.getWorkQueue();
            BlockingQueue<Runnable> other$workQueue = other.getWorkQueue();
            if (this$workQueue == null ? other$workQueue != null : !this$workQueue.equals(other$workQueue)) {
                return false;
            }
            RejectedExecutionHandler this$rejectedExecutionHandler = this.getRejectedExecutionHandler();
            RejectedExecutionHandler other$rejectedExecutionHandler = other.getRejectedExecutionHandler();
            if (this$rejectedExecutionHandler == null ? other$rejectedExecutionHandler != null : !this$rejectedExecutionHandler.equals(other$rejectedExecutionHandler)) {
                return false;
            }
            ThreadFactory this$threadFactory = this.getThreadFactory();
            ThreadFactory other$threadFactory = other.getThreadFactory();
            if (this$threadFactory == null ? other$threadFactory != null : !this$threadFactory.equals(other$threadFactory)) {
                return false;
            }
            String this$threadPoolId = this.getThreadPoolId();
            String other$threadPoolId = other.getThreadPoolId();
            if (this$threadPoolId == null ? other$threadPoolId != null : !this$threadPoolId.equals(other$threadPoolId)) {
                return false;
            }
            ThreadPoolAlarm this$threadPoolAlarm = this.getThreadPoolAlarm();
            ThreadPoolAlarm other$threadPoolAlarm = other.getThreadPoolAlarm();
            return !(this$threadPoolAlarm == null ? other$threadPoolAlarm != null : !((Object)this$threadPoolAlarm).equals(other$threadPoolAlarm));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolInitParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $corePoolNum = this.getCorePoolNum();
            result = result * 59 + ($corePoolNum == null ? 43 : ((Object)$corePoolNum).hashCode());
            Integer $maxPoolNum = this.getMaxPoolNum();
            result = result * 59 + ($maxPoolNum == null ? 43 : ((Object)$maxPoolNum).hashCode());
            Long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            TimeUnit $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
            Integer $capacity = this.getCapacity();
            result = result * 59 + ($capacity == null ? 43 : ((Object)$capacity).hashCode());
            BlockingQueue<Runnable> $workQueue = this.getWorkQueue();
            result = result * 59 + ($workQueue == null ? 43 : $workQueue.hashCode());
            RejectedExecutionHandler $rejectedExecutionHandler = this.getRejectedExecutionHandler();
            result = result * 59 + ($rejectedExecutionHandler == null ? 43 : $rejectedExecutionHandler.hashCode());
            ThreadFactory $threadFactory = this.getThreadFactory();
            result = result * 59 + ($threadFactory == null ? 43 : $threadFactory.hashCode());
            String $threadPoolId = this.getThreadPoolId();
            result = result * 59 + ($threadPoolId == null ? 43 : $threadPoolId.hashCode());
            ThreadPoolAlarm $threadPoolAlarm = this.getThreadPoolAlarm();
            result = result * 59 + ($threadPoolAlarm == null ? 43 : ((Object)$threadPoolAlarm).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractBuildThreadPoolTemplate.ThreadPoolInitParam(corePoolNum=" + this.getCorePoolNum() + ", maxPoolNum=" + this.getMaxPoolNum() + ", keepAliveTime=" + this.getKeepAliveTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ", capacity=" + this.getCapacity() + ", workQueue=" + this.getWorkQueue() + ", rejectedExecutionHandler=" + this.getRejectedExecutionHandler() + ", threadFactory=" + this.getThreadFactory() + ", threadPoolId=" + this.getThreadPoolId() + ", threadPoolAlarm=" + this.getThreadPoolAlarm() + ")";
        }
    }
}

