/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    @Autowired
    private OkHttpClient okHttpClient;
    private MediaType jsonMediaType = MediaType.parse((String)"application/json; charset=utf-8");
    private static int HTTP_OK_CODE = 200;

    public String get(String url) {
        try {
            return new String(this.doGet(url), "utf-8");
        }
        catch (Exception e) {
            log.error("httpGet \u8c03\u7528\u5931\u8d25. {}", (Object)url, (Object)e);
            throw e;
        }
    }

    public String get(String url, Map<String, String> queryString) {
        String fullUrl = this.buildUrl(url, queryString);
        return this.get(fullUrl);
    }

    public <T> T restApiGet(String url, Class<T> clazz) {
        String resp = this.get(url);
        return (T)JSON.parseObject((String)resp, clazz);
    }

    public <T> T restApiGet(String url, Map<String, String> queryString, Class<T> clazz) {
        String fullUrl = this.buildUrl(url, queryString);
        String resp = this.get(fullUrl);
        return (T)JSON.parseObject((String)resp, clazz);
    }

    public String restApiPost(String url, Object body) {
        try {
            return this.doPost(url, body);
        }
        catch (Exception e) {
            log.error("httpPost \u8c03\u7528\u5931\u8d25. {}", (Object)url, (Object)e);
            throw e;
        }
    }

    public <T> T restApiPost(String url, Object body, Class<T> clazz) {
        String resp = this.restApiPost(url, body);
        return (T)JSON.parseObject((String)resp, clazz);
    }

    public String buildUrl(String url, Map<String, String> queryString) {
        if (null == queryString) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : queryString.entrySet()) {
            String key = entry.getKey();
            if (key == null || entry.getValue() == null) continue;
            if (isFirst) {
                isFirst = false;
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(key).append("=").append(queryString.get(key));
        }
        return builder.toString();
    }

    private String doPost(String url, Object body) {
        String jsonBody = JSON.toJSONString((Object)body);
        RequestBody requestBody = RequestBody.create((MediaType)this.jsonMediaType, (String)jsonBody);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response resp = this.okHttpClient.newCall(request).execute();
        if (resp.code() != HTTP_OK_CODE) {
            String msg = String.format("HttpPost \u54cd\u5e94 code \u5f02\u5e38. [code] %s [url] %s [body] %s", resp.code(), url, jsonBody);
            throw new RuntimeException(msg);
        }
        return resp.body().string();
    }

    private byte[] doGet(String url) {
        Request request = new Request.Builder().get().url(url).build();
        Response resp = this.okHttpClient.newCall(request).execute();
        if (resp.code() != HTTP_OK_CODE) {
            String msg = String.format("HttpGet \u54cd\u5e94 code \u5f02\u5e38. [code] %s [url] %s", resp.code(), url);
            throw new RuntimeException(msg);
        }
        return resp.body().bytes();
    }

    public <T> T restApiGetByThreadPool(String url, Map<String, String> headers, Map<String, String> paramValues, Long readTimeoutMs, Class<T> clazz) {
        String buildUrl = this.buildUrl(url, paramValues);
        Request.Builder builder = new Request.Builder().get();
        if (!CollectionUtils.isEmpty(headers)) {
            builder.headers(Headers.of(headers));
        }
        Request request = builder.url(buildUrl).build();
        Call call = this.okHttpClient.newCall(request);
        call.timeout().timeout(readTimeoutMs.longValue(), TimeUnit.MILLISECONDS);
        Response resp = call.execute();
        if (resp.code() != HTTP_OK_CODE) {
            String msg = String.format("HttpGet \u54cd\u5e94 code \u5f02\u5e38. [code] %s [url] %s", resp.code(), url);
            log.error(msg);
            throw new RuntimeException(msg);
        }
        return (T)JSON.parseObject((String)resp.body().string(), clazz);
    }

    public <T> T restApiPostByThreadPool(String url, Map<String, String> headers, Map<String, String> paramValues, Long readTimeoutMs, Class<T> clazz) {
        String buildUrl = this.buildUrl(url, paramValues);
        Request request = new Request.Builder().url(buildUrl).headers(Headers.of(headers)).post(RequestBody.create((MediaType)this.jsonMediaType, (String)"")).build();
        Call call = this.okHttpClient.newCall(request);
        call.timeout().timeout(readTimeoutMs.longValue(), TimeUnit.MILLISECONDS);
        Response resp = call.execute();
        if (resp.code() != HTTP_OK_CODE) {
            String msg = String.format("HttpPost \u54cd\u5e94 code \u5f02\u5e38. [code] %s [url] %s.", resp.code(), url);
            log.error(msg);
            throw new RuntimeException(msg);
        }
        return (T)JSON.parseObject((String)resp.body().string(), clazz);
    }
}

