/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.toolkit;

import cn.hippo4j.starter.toolkit.inet.InetUtils;
import org.springframework.core.env.PropertyResolver;

public class CloudCommonIdUtil {
    private static final String SEPARATOR = ":";

    public static String getDefaultInstanceId(PropertyResolver resolver, InetUtils inetUtils) {
        String namePart = CloudCommonIdUtil.getIpApplicationName(resolver, inetUtils);
        String indexPart = resolver.getProperty("spring.application.instance_id", resolver.getProperty("server.port"));
        return CloudCommonIdUtil.combineParts(namePart, SEPARATOR, indexPart);
    }

    public static String getIpApplicationName(PropertyResolver resolver, InetUtils inetUtils) {
        String hostname = inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        String appName = resolver.getProperty("spring.application.name");
        return CloudCommonIdUtil.combineParts(hostname, SEPARATOR, appName);
    }

    public static String combineParts(String firstPart, String separator, String secondPart) {
        String combined = null;
        if (firstPart != null && secondPart != null) {
            combined = firstPart + separator + secondPart;
        } else if (firstPart != null) {
            combined = firstPart;
        } else if (secondPart != null) {
            combined = secondPart;
        }
        return combined;
    }
}

