/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.remote;

import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.remote.ServerListManager;
import cn.hippo4j.starter.toolkit.HttpClientUtil;
import java.util.Map;

public class ServerHttpAgent
implements HttpAgent {
    private final BootstrapProperties dynamicThreadPoolProperties;
    private final ServerListManager serverListManager;
    private final HttpClientUtil httpClientUtil;

    public ServerHttpAgent(BootstrapProperties properties, HttpClientUtil httpClientUtil) {
        this.dynamicThreadPoolProperties = properties;
        this.httpClientUtil = httpClientUtil;
        this.serverListManager = new ServerListManager(this.dynamicThreadPoolProperties);
    }

    @Override
    public void start() {
    }

    @Override
    public String getTenantId() {
        return this.dynamicThreadPoolProperties.getNamespace();
    }

    @Override
    public String getEncode() {
        return null;
    }

    @Override
    public Result httpPostByDiscovery(String path, Object body) {
        return this.httpClientUtil.restApiPost(this.buildUrl(path), body, Result.class);
    }

    @Override
    public Result httpGetByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        return this.httpClientUtil.restApiGetByThreadPool(this.buildUrl(path), headers, paramValues, readTimeoutMs, Result.class);
    }

    @Override
    public Result httpPostByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        return this.httpClientUtil.restApiPostByThreadPool(this.buildUrl(path), headers, paramValues, readTimeoutMs, Result.class);
    }

    @Override
    public Result httpDeleteByConfig(String path, Map<String, String> headers, Map<String, String> paramValues, long readTimeoutMs) {
        return null;
    }

    private String buildUrl(String path) {
        return this.serverListManager.getCurrentServerAddr() + path;
    }
}

