/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.handler;

import cn.hippo4j.common.model.PoolRunStateInfo;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.toolkit.ByteConvertUtil;
import cn.hippo4j.starter.toolkit.CalculateUtil;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.RuntimeInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolRunStateHandler {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolRunStateHandler.class);
    private static InetAddress INET_ADDRESS;

    public static PoolRunStateInfo getPoolRunState(String tpId) {
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(tpId);
        DynamicThreadPoolExecutor pool = executorService.getPool();
        int corePoolSize = ((ThreadPoolExecutor)pool).getCorePoolSize();
        int maximumPoolSize = ((ThreadPoolExecutor)pool).getMaximumPoolSize();
        int poolSize = ((ThreadPoolExecutor)pool).getPoolSize();
        int activeCount = ((ThreadPoolExecutor)pool).getActiveCount();
        int largestPoolSize = ((ThreadPoolExecutor)pool).getLargestPoolSize();
        long completedTaskCount = ((ThreadPoolExecutor)pool).getCompletedTaskCount();
        String currentLoad = CalculateUtil.divide(activeCount, maximumPoolSize) + "%";
        String peakLoad = CalculateUtil.divide(largestPoolSize, maximumPoolSize) + "%";
        BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)pool).getQueue();
        String queueType = queue.getClass().getSimpleName();
        int queueSize = queue.size();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        RuntimeInfo runtimeInfo = new RuntimeInfo();
        String memoryProportion = StrUtil.builder((CharSequence[])new CharSequence[]{"\u5df2\u5206\u914d: ", ByteConvertUtil.getPrintSize(runtimeInfo.getTotalMemory()), " / \u6700\u5927\u53ef\u7528: ", ByteConvertUtil.getPrintSize(runtimeInfo.getMaxMemory())}).toString();
        PoolRunStateInfo stateInfo = new PoolRunStateInfo();
        stateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        stateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        stateInfo.setPoolSize(Integer.valueOf(poolSize));
        stateInfo.setActiveSize(Integer.valueOf(activeCount));
        stateInfo.setCurrentLoad(currentLoad);
        stateInfo.setPeakLoad(peakLoad);
        stateInfo.setQueueType(queueType);
        stateInfo.setQueueSize(Integer.valueOf(queueSize));
        stateInfo.setQueueRemainingCapacity(Integer.valueOf(remainingCapacity));
        stateInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        stateInfo.setLargestPoolSize(Integer.valueOf(largestPoolSize));
        stateInfo.setCompletedTaskCount(Long.valueOf(completedTaskCount));
        stateInfo.setHost(INET_ADDRESS.getHostAddress());
        stateInfo.setTpId(tpId);
        stateInfo.setMemoryProportion(memoryProportion);
        stateInfo.setFreeMemory(ByteConvertUtil.getPrintSize(runtimeInfo.getFreeMemory()));
        int rejectCount = pool instanceof DynamicThreadPoolExecutor ? pool.getRejectCount() : -1;
        stateInfo.setRejectCount(Integer.valueOf(rejectCount));
        return stateInfo;
    }

    static {
        try {
            INET_ADDRESS = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            log.error("Local IP acquisition failed.", (Throwable)ex);
        }
    }
}

