/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.alarm.ThreadPoolAlarmManage;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import cn.hippo4j.starter.toolkit.thread.RejectedTypeEnum;
import cn.hippo4j.starter.toolkit.thread.ResizableCapacityLinkedBlockIngQueue;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolDynamicRefresh {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolDynamicRefresh.class);

    public static void refreshDynamicPool(String content) {
        PoolParameterInfo parameter = (PoolParameterInfo)JSON.parseObject((String)content, PoolParameterInfo.class);
        ThreadPoolAlarmManage.sendPoolConfigChange(parameter);
        ThreadPoolDynamicRefresh.refreshDynamicPool(parameter);
    }

    public static void refreshDynamicPool(PoolParameterInfo parameter) {
        String threadPoolId = parameter.getTpId();
        DynamicThreadPoolExecutor executor = GlobalThreadPoolManage.getExecutorService(threadPoolId).getPool();
        int originalCoreSize = ((ThreadPoolExecutor)executor).getCorePoolSize();
        int originalMaximumPoolSize = ((ThreadPoolExecutor)executor).getMaximumPoolSize();
        String originalQuery = ((ThreadPoolExecutor)executor).getQueue().getClass().getSimpleName();
        int originalCapacity = ((ThreadPoolExecutor)executor).getQueue().remainingCapacity() + ((ThreadPoolExecutor)executor).getQueue().size();
        long originalKeepAliveTime = ((ThreadPoolExecutor)executor).getKeepAliveTime(TimeUnit.SECONDS);
        String originalRejected = ((ThreadPoolExecutor)executor).getRejectedExecutionHandler().getClass().getSimpleName();
        ThreadPoolDynamicRefresh.changePoolInfo(executor, parameter);
        DynamicThreadPoolExecutor afterExecutor = GlobalThreadPoolManage.getExecutorService(threadPoolId).getPool();
        log.info("[\ud83d\udd25 {}] Changed thread pool. \ncoreSize :: [{}], maxSize :: [{}], queueType :: [{}], capacity :: [{}], keepAliveTime :: [{}], rejectedType :: [{}]", new Object[]{threadPoolId.toUpperCase(), String.format("%s => %s", originalCoreSize, ((ThreadPoolExecutor)afterExecutor).getCorePoolSize()), String.format("%s => %s", originalMaximumPoolSize, ((ThreadPoolExecutor)afterExecutor).getMaximumPoolSize()), String.format("%s => %s", originalQuery, QueueTypeEnum.getBlockingQueueNameByType(parameter.getQueueType())), String.format("%s => %s", originalCapacity, ((ThreadPoolExecutor)afterExecutor).getQueue().remainingCapacity() + ((ThreadPoolExecutor)afterExecutor).getQueue().size()), String.format("%s => %s", originalKeepAliveTime, ((ThreadPoolExecutor)afterExecutor).getKeepAliveTime(TimeUnit.SECONDS)), String.format("%s => %s", originalRejected, RejectedTypeEnum.getRejectedNameByType(parameter.getRejectedType()))});
    }

    public static void changePoolInfo(ThreadPoolExecutor executor, PoolParameterInfo parameter) {
        if (parameter.getCoreSize() != null) {
            executor.setCorePoolSize(parameter.getCoreSize());
        }
        if (parameter.getMaxSize() != null) {
            executor.setMaximumPoolSize(parameter.getMaxSize());
        }
        if (parameter.getCapacity() != null && Objects.equals(QueueTypeEnum.RESIZABLE_LINKED_BLOCKING_QUEUE.type, parameter.getQueueType())) {
            if (executor.getQueue() instanceof ResizableCapacityLinkedBlockIngQueue) {
                ResizableCapacityLinkedBlockIngQueue queue = (ResizableCapacityLinkedBlockIngQueue)executor.getQueue();
                queue.setCapacity(parameter.getCapacity());
            } else {
                log.warn("[Pool change] The queue length cannot be modified. Queue type mismatch. Current queue type :: {}", (Object)executor.getQueue().getClass().getSimpleName());
            }
        }
        if (parameter.getKeepAliveTime() != null) {
            executor.setKeepAliveTime(parameter.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
        }
        if (parameter.getRejectedType() != null) {
            executor.setRejectedExecutionHandler(RejectedTypeEnum.createPolicy(parameter.getRejectedType()));
        }
    }
}

