/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.core;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.base.Results;
import cn.hippo4j.common.web.exception.ErrorCodeEnum;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.toolkit.thread.ThreadFactoryBuilder;
import cn.hippo4j.starter.toolkit.thread.ThreadPoolBuilder;
import cn.hutool.core.util.StrUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClient.class);
    private final ThreadPoolExecutor heartbeatExecutor;
    private final ScheduledExecutorService scheduler;
    private final HttpAgent httpAgent;
    private final InstanceInfo instanceInfo;
    private volatile long lastSuccessfulHeartbeatTimestamp = -1L;
    private static final String PREFIX = "DiscoveryClient_";
    private final String appPathIdentifier;

    public DiscoveryClient(HttpAgent httpAgent, InstanceInfo instanceInfo) {
        this.httpAgent = httpAgent;
        this.instanceInfo = instanceInfo;
        this.appPathIdentifier = instanceInfo.getAppName().toUpperCase() + "/" + instanceInfo.getInstanceId();
        this.heartbeatExecutor = ThreadPoolBuilder.builder().poolThreadSize(1, 5).keepAliveTime(0L, TimeUnit.SECONDS).workQueue(new SynchronousQueue()).threadFactory("DiscoveryClient-HeartbeatExecutor", true).build();
        this.scheduler = Executors.newScheduledThreadPool(2, ThreadFactoryBuilder.builder().daemon(true).prefix("DiscoveryClient-Scheduler").build());
        this.register();
        this.initScheduledTasks();
    }

    private void initScheduledTasks() {
        this.scheduler.scheduleWithFixedDelay(new HeartbeatThread(), 30L, 30L, TimeUnit.SECONDS);
    }

    boolean register() {
        log.info("{}{} - registering service...", (Object)PREFIX, (Object)this.appPathIdentifier);
        String urlPath = "/v1/cs/apps/register/";
        Result registerResult = null;
        try {
            registerResult = this.httpAgent.httpPostByDiscovery(urlPath, this.instanceInfo);
        }
        catch (Exception ex) {
            registerResult = Results.failure((ErrorCodeEnum)ErrorCodeEnum.SERVICE_ERROR);
            log.error("{}{} - registration failed :: {}", new Object[]{PREFIX, this.appPathIdentifier, ex.getMessage(), ex});
        }
        if (log.isInfoEnabled()) {
            log.info("{}{} - registration status :: {}", new Object[]{PREFIX, this.appPathIdentifier, registerResult.isSuccess() ? "success" : "fail"});
        }
        return registerResult.isSuccess();
    }

    boolean renew() {
        Result renewResult = null;
        try {
            InstanceInfo.InstanceRenew instanceRenew = new InstanceInfo.InstanceRenew().setAppName(this.instanceInfo.getAppName()).setInstanceId(this.instanceInfo.getInstanceId()).setLastDirtyTimestamp(this.instanceInfo.getLastDirtyTimestamp().toString()).setStatus(this.instanceInfo.getStatus().toString());
            renewResult = this.httpAgent.httpPostByDiscovery("/v1/cs/apps/renew", instanceRenew);
            if (StrUtil.equals((CharSequence)ErrorCodeEnum.NOT_FOUND.getCode(), (CharSequence)renewResult.getCode())) {
                long timestamp = this.instanceInfo.setIsDirtyWithTime();
                boolean success = this.register();
                if (success) {
                    this.instanceInfo.unsetIsDirty(timestamp);
                }
                return success;
            }
            return renewResult.isSuccess();
        }
        catch (Exception ex) {
            log.error("DiscoveryClient_{} - was unable to send heartbeat!", (Object)this.appPathIdentifier, (Object)ex);
            return false;
        }
    }

    public class HeartbeatThread
    implements Runnable {
        @Override
        public void run() {
            if (DiscoveryClient.this.renew()) {
                DiscoveryClient.this.lastSuccessfulHeartbeatTimestamp = System.currentTimeMillis();
            }
        }
    }
}

