/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.config;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.starter.alarm.AlarmControlHandler;
import cn.hippo4j.starter.alarm.BaseSendMessageService;
import cn.hippo4j.starter.alarm.DingSendMessageHandler;
import cn.hippo4j.starter.alarm.SendMessageHandler;
import cn.hippo4j.starter.alarm.SendMessageService;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.remote.HttpAgent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;

public class MessageAlarmConfig {
    private final BootstrapProperties properties;
    private final InstanceInfo instanceInfo;
    private ConfigurableEnvironment environment;
    public static final String SEND_MESSAGE_BEAN_NAME = "sendMessageService";

    @DependsOn(value={"applicationContextHolder"})
    @Bean(value={"sendMessageService"})
    public SendMessageService sendMessageService(HttpAgent httpAgent, AlarmControlHandler alarmControlHandler) {
        return new BaseSendMessageService(httpAgent, this.properties, alarmControlHandler);
    }

    @Bean
    public SendMessageHandler dingSendMessageHandler() {
        String active = this.environment.getProperty("spring.profiles.active", "");
        return new DingSendMessageHandler(active, this.instanceInfo);
    }

    @Bean
    public AlarmControlHandler alarmControlHandler() {
        return new AlarmControlHandler();
    }

    public MessageAlarmConfig(BootstrapProperties properties, InstanceInfo instanceInfo, ConfigurableEnvironment environment) {
        this.properties = properties;
        this.instanceInfo = instanceInfo;
        this.environment = environment;
    }
}

