/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.config;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.config.CorsConfig;
import cn.hippo4j.starter.config.DiscoveryConfig;
import cn.hippo4j.starter.config.HttpClientConfig;
import cn.hippo4j.starter.config.MessageAlarmConfig;
import cn.hippo4j.starter.config.UtilAutoConfiguration;
import cn.hippo4j.starter.controller.PoolRunStateController;
import cn.hippo4j.starter.core.ConfigService;
import cn.hippo4j.starter.core.DynamicThreadPoolPostProcessor;
import cn.hippo4j.starter.core.ThreadPoolConfigService;
import cn.hippo4j.starter.core.ThreadPoolOperation;
import cn.hippo4j.starter.enable.MarkerConfiguration;
import cn.hippo4j.starter.handler.DynamicThreadPoolBannerHandler;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.toolkit.inet.InetUtils;
import cn.hutool.core.util.StrUtil;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@ConditionalOnBean(value={MarkerConfiguration.Marker.class})
@EnableConfigurationProperties(value={BootstrapProperties.class})
@ImportAutoConfiguration(value={HttpClientConfig.class, DiscoveryConfig.class, MessageAlarmConfig.class, UtilAutoConfiguration.class, CorsConfig.class})
public class DynamicThreadPoolAutoConfiguration {
    private final BootstrapProperties properties;
    private final ConfigurableEnvironment environment;

    @Bean
    public DynamicThreadPoolBannerHandler threadPoolBannerHandler() {
        return new DynamicThreadPoolBannerHandler(this.properties);
    }

    @Bean
    @Order(value=-2147483648)
    public ApplicationContextHolder applicationContextHolder() {
        return new ApplicationContextHolder();
    }

    @Bean
    public ConfigService configService(HttpAgent httpAgent, InetUtils inetUtils) {
        String ip = inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        String port = this.environment.getProperty("server.port");
        String identification = StrUtil.builder((CharSequence[])new CharSequence[]{ip, ":", port}).toString();
        return new ThreadPoolConfigService(httpAgent, identification);
    }

    @Bean
    public ThreadPoolOperation threadPoolOperation(ConfigService configService) {
        return new ThreadPoolOperation(this.properties, configService);
    }

    @Bean
    public DynamicThreadPoolPostProcessor threadPoolBeanPostProcessor(HttpAgent httpAgent, ThreadPoolOperation threadPoolOperation, ApplicationContextHolder applicationContextHolder) {
        return new DynamicThreadPoolPostProcessor(this.properties, httpAgent, threadPoolOperation);
    }

    @Bean
    public PoolRunStateController poolRunStateController() {
        return new PoolRunStateController();
    }

    public DynamicThreadPoolAutoConfiguration(BootstrapProperties properties, ConfigurableEnvironment environment) {
        this.properties = properties;
        this.environment = environment;
    }
}

