/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.config;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.toolkit.ContentUtil;
import cn.hippo4j.starter.config.BootstrapProperties;
import cn.hippo4j.starter.core.DiscoveryClient;
import cn.hippo4j.starter.remote.HttpAgent;
import cn.hippo4j.starter.toolkit.CloudCommonIdUtil;
import cn.hippo4j.starter.toolkit.inet.InetUtils;
import cn.hutool.core.util.StrUtil;
import java.net.InetAddress;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class DiscoveryConfig {
    private final ConfigurableEnvironment environment;
    private final BootstrapProperties properties;
    private final InetUtils inetUtils;

    @Bean
    public InstanceInfo instanceConfig() {
        InstanceInfo instanceInfo = new InstanceInfo();
        instanceInfo.setInstanceId(CloudCommonIdUtil.getDefaultInstanceId((PropertyResolver)this.environment, this.inetUtils)).setIpApplicationName(CloudCommonIdUtil.getIpApplicationName((PropertyResolver)this.environment, this.inetUtils)).setHostName(InetAddress.getLocalHost().getHostAddress()).setGroupKey(this.properties.getItemId() + "+" + this.properties.getNamespace()).setAppName(this.environment.getProperty("spring.application.name")).setClientBasePath(this.environment.getProperty("server.servlet.context-path")).setGroupKey(ContentUtil.getGroupKey((String[])new String[]{this.properties.getItemId(), this.properties.getNamespace()}));
        String callBackUrl = instanceInfo.getHostName() + ":" + this.environment.getProperty("server.port") + instanceInfo.getClientBasePath();
        instanceInfo.setCallBackUrl(callBackUrl);
        String ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        String port = this.environment.getProperty("server.port");
        String identification = StrUtil.builder((CharSequence[])new CharSequence[]{ip, ":", port}).toString();
        instanceInfo.setIdentify(identification);
        return instanceInfo;
    }

    @Bean
    public DiscoveryClient discoveryClient(HttpAgent httpAgent, InstanceInfo instanceInfo) {
        return new DiscoveryClient(httpAgent, instanceInfo);
    }

    public DiscoveryConfig(ConfigurableEnvironment environment, BootstrapProperties properties, InetUtils inetUtils) {
        this.environment = environment;
        this.properties = properties;
        this.inetUtils = inetUtils;
    }
}

