/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.alarm;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.alarm.MessageTypeEnum;
import cn.hippo4j.starter.alarm.SendMessageService;
import cn.hippo4j.starter.alarm.ThreadPoolAlarm;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.toolkit.CalculateUtil;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolAlarmManage {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolAlarmManage.class);
    private static final SendMessageService SEND_MESSAGE_SERVICE = Optional.ofNullable(ApplicationContextHolder.getInstance()).map(each -> (SendMessageService)each.getBean("sendMessageService", SendMessageService.class)).orElse(null);

    public static void checkPoolCapacityAlarm(DynamicThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        if (SEND_MESSAGE_SERVICE == null) {
            return;
        }
        ThreadPoolAlarm threadPoolAlarm = threadPoolExecutor.getThreadPoolAlarm();
        BlockingQueue<Runnable> blockIngQueue = threadPoolExecutor.getQueue();
        int queueSize = blockIngQueue.size();
        int capacity = queueSize + blockIngQueue.remainingCapacity();
        int divide = CalculateUtil.divide(queueSize, capacity);
        boolean bl = isSend = threadPoolAlarm.getIsAlarm() != false && divide > threadPoolAlarm.getCapacityAlarm() && ThreadPoolAlarmManage.isSendMessage(threadPoolExecutor, MessageTypeEnum.CAPACITY);
        if (isSend) {
            SEND_MESSAGE_SERVICE.sendAlarmMessage(MessageTypeEnum.CAPACITY, threadPoolExecutor);
        }
    }

    public static void checkPoolLivenessAlarm(boolean isCore, DynamicThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        if (isCore || SEND_MESSAGE_SERVICE == null || !ThreadPoolAlarmManage.isSendMessage(threadPoolExecutor, MessageTypeEnum.LIVENESS)) {
            return;
        }
        int activeCount = threadPoolExecutor.getActiveCount();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int divide = CalculateUtil.divide(activeCount, maximumPoolSize);
        ThreadPoolAlarm threadPoolAlarm = threadPoolExecutor.getThreadPoolAlarm();
        boolean bl = isSend = threadPoolAlarm.getIsAlarm() != false && divide > threadPoolAlarm.getLivenessAlarm() && ThreadPoolAlarmManage.isSendMessage(threadPoolExecutor, MessageTypeEnum.CAPACITY);
        if (isSend) {
            SEND_MESSAGE_SERVICE.sendAlarmMessage(MessageTypeEnum.CAPACITY, threadPoolExecutor);
        }
    }

    public static void checkPoolRejectAlarm(DynamicThreadPoolExecutor threadPoolExecutor) {
        if (SEND_MESSAGE_SERVICE == null) {
            return;
        }
        ThreadPoolAlarm threadPoolAlarm = threadPoolExecutor.getThreadPoolAlarm();
        if (threadPoolAlarm.getIsAlarm().booleanValue() && ThreadPoolAlarmManage.isSendMessage(threadPoolExecutor, MessageTypeEnum.REJECT)) {
            SEND_MESSAGE_SERVICE.sendAlarmMessage(MessageTypeEnum.REJECT, threadPoolExecutor);
        }
    }

    public static void sendPoolConfigChange(PoolParameterInfo parameter) {
        if (SEND_MESSAGE_SERVICE == null) {
            return;
        }
        SEND_MESSAGE_SERVICE.sendChangeMessage(parameter);
    }

    private static boolean isSendMessage(DynamicThreadPoolExecutor threadPoolExecutor, MessageTypeEnum typeEnum) {
        return true;
    }

    static {
        System.out.println();
    }
}

