/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.starter.alarm;

import cn.hippo4j.common.model.InstanceInfo;
import cn.hippo4j.common.model.PoolParameterInfo;
import cn.hippo4j.starter.alarm.NotifyDTO;
import cn.hippo4j.starter.alarm.NotifyPlatformEnum;
import cn.hippo4j.starter.alarm.SendMessageHandler;
import cn.hippo4j.starter.core.DynamicThreadPoolExecutor;
import cn.hippo4j.starter.core.GlobalThreadPoolManage;
import cn.hippo4j.starter.toolkit.thread.QueueTypeEnum;
import cn.hippo4j.starter.toolkit.thread.RejectedTypeEnum;
import cn.hippo4j.starter.wrapper.DynamicThreadPoolWrapper;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.google.common.base.Joiner;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingSendMessageHandler
implements SendMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DingSendMessageHandler.class);
    private String active;
    private InstanceInfo instanceInfo;

    @Override
    public String getType() {
        return NotifyPlatformEnum.DING.name();
    }

    @Override
    public void sendAlarmMessage(NotifyDTO notifyConfig, DynamicThreadPoolExecutor pool) {
        this.dingAlarmSendMessage(notifyConfig, pool);
    }

    @Override
    public void sendChangeMessage(NotifyDTO notifyConfig, PoolParameterInfo parameter) {
        this.dingChangeSendMessage(notifyConfig, parameter);
    }

    private void dingAlarmSendMessage(NotifyDTO notifyConfig, DynamicThreadPoolExecutor pool) {
        List receives = StrUtil.split((CharSequence)notifyConfig.getReceives(), (char)',');
        String afterReceives = Joiner.on((String)", @").join((Iterable)receives);
        BlockingQueue<Runnable> queue = pool.getQueue();
        String text = String.format("<font color='#FF0000'>[\u8b66\u62a5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u8fd0\u884c\u544a\u8b66 \n\n --- \n\n <font color='#708090' size=2>\u7ebf\u7a0b\u6c60ID\uff1a%s</font> \n\n <font color='#708090' size=2>\u5e94\u7528\u540d\u79f0\uff1a%s</font> \n\n <font color='#778899' size=2>\u5e94\u7528\u5b9e\u4f8b\uff1a%s</font> \n\n <font color='#778899' size=2>\u62a5\u8b66\u7c7b\u578b\uff1a%s</font> \n\n  --- \n\n  <font color='#708090' size=2>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u5f53\u524d\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u7ebf\u7a0b\u6c60\u4efb\u52a1\u603b\u91cf\uff1a%d</font> \n\n  --- \n\n  <font color='#708090' size=2>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n\n <font color='#708090' size=2>\u961f\u5217\u5bb9\u91cf\uff1a%d</font> \n\n <font color='#708090' size=2>\u961f\u5217\u5143\u7d20\u4e2a\u6570\uff1a%d</font> \n\n <font color='#708090' size=2>\u961f\u5217\u5269\u4f59\u4e2a\u6570\uff1a%d</font> \n\n  --- \n\n  <font color='#708090' size=2>\u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n<font color='#708090' size=2>\u62d2\u7edd\u7b56\u7565\u6267\u884c\u6b21\u6570\uff1a</font><font color='#FF0000' size=2>%d</font> \n\n <font color='#708090' size=2>OWNER\uff1a@%s</font> \n\n<font color='#708090' size=2>\u63d0\u793a\uff1a%d \u5206\u949f\u5185\u6b64\u7ebf\u7a0b\u6c60\u4e0d\u4f1a\u91cd\u590d\u544a\u8b66\uff08\u53ef\u914d\u7f6e\uff09</font> \n\n --- \n\n  **\u64ad\u62a5\u65f6\u95f4\uff1a%s**", new Object[]{this.active.toUpperCase(), pool.getThreadPoolId(), this.instanceInfo.getAppName(), this.instanceInfo.getIdentify(), notifyConfig.getTypeEnum(), pool.getCorePoolSize(), pool.getMaximumPoolSize(), pool.getPoolSize(), pool.getActiveCount(), pool.getLargestPoolSize(), pool.getCompletedTaskCount(), queue.getClass().getSimpleName(), queue.size() + queue.remainingCapacity(), queue.size(), queue.remainingCapacity(), pool.getRejectedExecutionHandler().getClass().getSimpleName(), pool.getRejectCount(), afterReceives, notifyConfig.getInterval(), DateUtil.now()});
        this.execute(notifyConfig, "\u52a8\u6001\u7ebf\u7a0b\u6c60\u544a\u8b66", text, receives);
    }

    private void dingChangeSendMessage(NotifyDTO notifyConfig, PoolParameterInfo parameter) {
        String threadPoolId = parameter.getTpId();
        DynamicThreadPoolWrapper poolWrap = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        if (poolWrap == null) {
            log.warn("Thread pool is empty when sending change notification, threadPoolId :: {}", (Object)threadPoolId);
            return;
        }
        List receives = StrUtil.split((CharSequence)notifyConfig.getReceives(), (char)',');
        String afterReceives = Joiner.on((String)", @").join((Iterable)receives);
        DynamicThreadPoolExecutor customPool = poolWrap.getPool();
        String text = String.format("<font color='#2a9d8f'>[\u901a\u77e5] </font>%s - \u52a8\u6001\u7ebf\u7a0b\u6c60\u53c2\u6570\u53d8\u66f4 \n\n --- \n\n <font color='#708090' size=2>\u7ebf\u7a0b\u6c60ID\uff1a%s</font> \n\n <font color='#708090' size=2>\u5e94\u7528\u540d\u79f0\uff1a%s</font> \n\n <font color='#778899' size=2>\u5e94\u7528\u5b9e\u4f8b\uff1a%s</font> \n\n  --- \n\n  <font color='#708090' size=2>\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a%s</font> \n\n <font color='#708090' size=2>\u6700\u5927\u7ebf\u7a0b\u6570\uff1a%s</font> \n\n <font color='#708090' size=2>\u7ebf\u7a0b\u5b58\u6d3b\u65f6\u95f4\uff1a%s / SECONDS</font> \n\n --- \n\n  <font color='#708090' size=2>\u961f\u5217\u7c7b\u578b\uff1a%s</font> \n\n <font color='#708090' size=2>\u961f\u5217\u5bb9\u91cf\uff1a%s</font> \n\n  --- \n\n  <font color='#708090' size=2>AGO \u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n<font color='#708090' size=2>NOW \u62d2\u7edd\u7b56\u7565\uff1a%s</font> \n\n --- \n\n  <font color='#708090' size=2>\u63d0\u793a\uff1a\u52a8\u6001\u7ebf\u7a0b\u6c60\u914d\u7f6e\u53d8\u66f4\u5b9e\u65f6\u901a\u77e5\uff08\u65e0\u9650\u5236\uff09</font> \n\n<font color='#708090' size=2>OWNER\uff1a@%s</font> \n\n --- \n\n  **\u64ad\u62a5\u65f6\u95f4\uff1a%s**", this.active.toUpperCase(), threadPoolId, this.instanceInfo.getAppName(), this.instanceInfo.getIdentify(), customPool.getCorePoolSize() + "  \u27b2  " + parameter.getCoreSize(), customPool.getMaximumPoolSize() + "  \u27b2  " + parameter.getMaxSize(), customPool.getKeepAliveTime(TimeUnit.SECONDS) + "  \u27b2  " + parameter.getKeepAliveTime(), QueueTypeEnum.getBlockingQueueNameByType(parameter.getQueueType()), customPool.getQueue().size() + customPool.getQueue().remainingCapacity() + "  \u27b2  " + parameter.getCapacity(), customPool.getRejectedExecutionHandler().getClass().getSimpleName(), RejectedTypeEnum.getRejectedNameByType(parameter.getRejectedType()), afterReceives, DateUtil.now());
        this.execute(notifyConfig, "\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5", text, receives);
    }

    private void execute(NotifyDTO notifyConfig, String title, String text, List<String> mobiles) {
        String url = "https://oapi.dingtalk.com/robot/send?access_token=";
        String serverUrl = url + notifyConfig.getSecretKey();
        DefaultDingTalkClient dingTalkClient = new DefaultDingTalkClient(serverUrl);
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle(title);
        markdown.setText(text);
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles(mobiles);
        request.setAt(at);
        request.setMarkdown(markdown);
        try {
            dingTalkClient.execute((TaobaoRequest)request);
        }
        catch (ApiException ex) {
            log.error("Ding failed to send message", (Object)ex.getMessage());
        }
    }

    public DingSendMessageHandler(String active, InstanceInfo instanceInfo) {
        this.active = active;
        this.instanceInfo = instanceInfo;
    }
}

