/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.adapter.web;

import cn.hippo4j.adapter.web.WebThreadPoolRunStateHandler;
import cn.hippo4j.adapter.web.jetty.DefaultJettyWebThreadPoolHandler;
import cn.hippo4j.adapter.web.jetty.JettyWebThreadPoolHandlerAdapt;
import cn.hippo4j.adapter.web.tomcat.DefaultTomcatWebThreadPoolHandler;
import cn.hippo4j.adapter.web.tomcat.TomcatWebThreadPoolHandlerAdapt;
import cn.hippo4j.adapter.web.undertow.DefaultUndertowWebThreadPoolHandler;
import cn.hippo4j.adapter.web.undertow.UndertowWebThreadPoolHandlerAdapt;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import io.undertow.Undertow;
import javax.servlet.Servlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.xnio.SslClientAuthMode;

@Configuration(proxyBeanMethods=false)
public class WebThreadPoolHandlerConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
    @ConditionalOnBean(value={ConfigurableUndertowWebServerFactory.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnMissingBean(value={DefaultUndertowWebThreadPoolHandler.class, UndertowWebThreadPoolHandlerAdapt.class})
    static class EmbeddedUndertow {
        EmbeddedUndertow() {
        }

        @Bean
        public UndertowWebThreadPoolHandlerAdapt undertowWebThreadPoolHandler() {
            return new DefaultUndertowWebThreadPoolHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    @ConditionalOnBean(value={ConfigurableJettyWebServerFactory.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnMissingBean(value={DefaultJettyWebThreadPoolHandler.class, JettyWebThreadPoolHandlerAdapt.class})
    static class EmbeddedJetty {
        EmbeddedJetty() {
        }

        @Bean
        public JettyWebThreadPoolHandlerAdapt jettyWebThreadPoolHandler() {
            return new DefaultJettyWebThreadPoolHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Tomcat.class, UpgradeProtocol.class})
    @ConditionalOnBean(value={ConfigurableTomcatWebServerFactory.class}, search=SearchStrategy.CURRENT)
    @ConditionalOnMissingBean(value={DefaultTomcatWebThreadPoolHandler.class, TomcatWebThreadPoolHandlerAdapt.class})
    static class EmbeddedTomcat {
        EmbeddedTomcat() {
        }

        @Bean
        public TomcatWebThreadPoolHandlerAdapt tomcatWebThreadPoolHandler(WebThreadPoolRunStateHandler webThreadPoolRunStateHandler) {
            return new DefaultTomcatWebThreadPoolHandler((AbstractThreadPoolRuntime)webThreadPoolRunStateHandler);
        }
    }
}

