/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.springboot.starter.adapter.web;

import cn.hippo4j.adapter.web.JettyWebThreadPoolHandler;
import cn.hippo4j.adapter.web.TomcatWebThreadPoolHandler;
import cn.hippo4j.adapter.web.UndertowWebThreadPoolHandler;
import cn.hippo4j.adapter.web.WebThreadPoolRunStateHandler;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import io.undertow.Undertow;
import javax.servlet.Servlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.xnio.SslClientAuthMode;

@Configuration(proxyBeanMethods=false)
public class WebThreadPoolHandlerConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Undertow.class, SslClientAuthMode.class})
    @ConditionalOnBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    static class EmbeddedUndertow {
        EmbeddedUndertow() {
        }

        @Bean
        public UndertowWebThreadPoolHandler undertowWebThreadPoolHandler() {
            return new UndertowWebThreadPoolHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class, WebAppContext.class})
    @ConditionalOnBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    static class EmbeddedJetty {
        EmbeddedJetty() {
        }

        @Bean
        public JettyWebThreadPoolHandler jettyWebThreadPoolHandler() {
            return new JettyWebThreadPoolHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Servlet.class, Tomcat.class, UpgradeProtocol.class})
    @ConditionalOnBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    static class EmbeddedTomcat {
        EmbeddedTomcat() {
        }

        @Bean
        public TomcatWebThreadPoolHandler tomcatWebThreadPoolHandler(WebThreadPoolRunStateHandler webThreadPoolRunStateHandler) {
            return new TomcatWebThreadPoolHandler((AbstractThreadPoolRuntime)webThreadPoolRunStateHandler);
        }
    }
}

