/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.monitor.prometheus;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.core.executor.state.ThreadPoolRunStateHandler;
import cn.hippo4j.monitor.base.AbstractDynamicThreadPoolMonitor;
import cn.hippo4j.monitor.base.MonitorTypeEnum;
import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.core.env.Environment;

public class PrometheusMonitorHandler
extends AbstractDynamicThreadPoolMonitor {
    private static final String METRIC_NAME_PREFIX = "dynamic.thread-pool";
    private static final String DYNAMIC_THREAD_POOL_ID_TAG = "dynamic.thread-pool.id";
    private static final String APPLICATION_NAME_TAG = "application.name";
    private final Map<String, ThreadPoolRunStateInfo> RUN_STATE_CACHE = Maps.newConcurrentMap();

    public PrometheusMonitorHandler(ThreadPoolRunStateHandler threadPoolRunStateHandler) {
        super(threadPoolRunStateHandler);
    }

    protected void execute(ThreadPoolRunStateInfo poolRunStateInfo) {
        ThreadPoolRunStateInfo stateInfo = this.RUN_STATE_CACHE.get(poolRunStateInfo.getTpId());
        if (stateInfo == null) {
            this.RUN_STATE_CACHE.put(poolRunStateInfo.getTpId(), poolRunStateInfo);
        } else {
            BeanUtil.copyProperties((Object)poolRunStateInfo, (Object)stateInfo, (String[])new String[0]);
        }
        Environment environment = ApplicationContextHolder.getInstance().getEnvironment();
        String applicationName = environment.getProperty("spring.application.name", "application");
        ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)DYNAMIC_THREAD_POOL_ID_TAG, (String)poolRunStateInfo.getTpId()), Tag.of((String)APPLICATION_NAME_TAG, (String)applicationName)});
        Metrics.gauge((String)this.metricName("current.load"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getSimpleCurrentLoad);
        Metrics.gauge((String)this.metricName("peak.load"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getSimplePeakLoad);
        Metrics.gauge((String)this.metricName("core.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolBaseInfo::getCoreSize);
        Metrics.gauge((String)this.metricName("maximum.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolBaseInfo::getMaximumSize);
        Metrics.gauge((String)this.metricName("current.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getPoolSize);
        Metrics.gauge((String)this.metricName("largest.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getLargestPoolSize);
        Metrics.gauge((String)this.metricName("active.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getActiveSize);
        Metrics.gauge((String)this.metricName("queue.size"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getQueueSize);
        Metrics.gauge((String)this.metricName("queue.capacity"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolBaseInfo::getQueueCapacity);
        Metrics.gauge((String)this.metricName("queue.remaining.capacity"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getQueueRemainingCapacity);
        Metrics.gauge((String)this.metricName("completed.task.count"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getCompletedTaskCount);
        Metrics.gauge((String)this.metricName("reject.count"), (Iterable)tags, (Object)poolRunStateInfo, ThreadPoolRunStateInfo::getRejectCount);
    }

    private String metricName(String name) {
        return String.join((CharSequence)".", METRIC_NAME_PREFIX, name);
    }

    public String getType() {
        return MonitorTypeEnum.PROMETHEUS.name().toLowerCase();
    }
}

