/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.monitor.es;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.core.executor.state.ThreadPoolRunStateHandler;
import cn.hippo4j.monitor.base.AbstractDynamicThreadPoolMonitor;
import cn.hippo4j.monitor.base.MonitorTypeEnum;
import cn.hippo4j.monitor.es.EsClientHolder;
import cn.hippo4j.monitor.es.model.EsThreadPoolRunStateInfo;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class EsMonitorHandler
extends AbstractDynamicThreadPoolMonitor {
    private static final Logger log = LoggerFactory.getLogger(EsMonitorHandler.class);
    private AtomicBoolean isIndexExist = null;

    public EsMonitorHandler(ThreadPoolRunStateHandler threadPoolRunStateHandler) {
        super(threadPoolRunStateHandler);
    }

    protected void execute(ThreadPoolRunStateInfo poolRunStateInfo) {
        EsThreadPoolRunStateInfo esThreadPoolRunStateInfo = new EsThreadPoolRunStateInfo();
        BeanUtil.copyProperties((Object)poolRunStateInfo, (Object)((Object)esThreadPoolRunStateInfo), (String[])new String[0]);
        Environment environment = ApplicationContextHolder.getInstance().getEnvironment();
        String indexName = environment.getProperty("es.thread-pool-state.index.name", "thread-pool-state");
        String applicationName = environment.getProperty("spring.application.name", "application");
        if (!this.isExists(indexName)) {
            List rawMapping = FileUtil.readLines((File)new File(Thread.currentThread().getContextClassLoader().getResource("mapping.json").getPath()), (Charset)StandardCharsets.UTF_8);
            String mapping = String.join((CharSequence)" ", rawMapping);
            this.createIndex(indexName, "_doc", mapping, null, null, null);
        }
        esThreadPoolRunStateInfo.setApplicationName(applicationName);
        esThreadPoolRunStateInfo.setId(indexName + "-" + System.currentTimeMillis());
        this.log2Es(esThreadPoolRunStateInfo, indexName);
    }

    public void log2Es(EsThreadPoolRunStateInfo esThreadPoolRunStateInfo, String indexName) {
        RestHighLevelClient client = EsClientHolder.getClient();
        try {
            IndexRequest request = new IndexRequest(indexName, "_doc");
            request.id(esThreadPoolRunStateInfo.getId());
            String stateJson = JSONUtil.toJSONString((Object)((Object)esThreadPoolRunStateInfo));
            request.source(stateJson, XContentType.JSON);
            IndexResponse response = client.index(request, RequestOptions.DEFAULT);
            log.info("write thread-pool state to es, id is :{}", (Object)response.getId());
        }
        catch (Exception ex) {
            log.error("es index error, the exception was thrown in create index. name:{},type:{},id:{}. {} ", new Object[]{indexName, "_doc", esThreadPoolRunStateInfo.getId(), ex});
        }
    }

    public synchronized boolean isExists(String index) {
        if (Objects.isNull(this.isIndexExist)) {
            boolean exists = false;
            GetIndexRequest request = new GetIndexRequest(new String[]{index});
            try {
                RestHighLevelClient client = EsClientHolder.getClient();
                exists = client.indices().exists(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                log.error("check es index fail");
            }
            this.isIndexExist = new AtomicBoolean(exists);
        }
        return this.isIndexExist.get();
    }

    public void createIndex(String index, String type, String mapping, Integer shards, Integer replicas, String alias) {
        RestHighLevelClient client = EsClientHolder.getClient();
        boolean acknowledged = false;
        CreateIndexRequest request = new CreateIndexRequest(index);
        if (StringUtils.hasText((String)mapping)) {
            request.mapping(type, mapping, XContentType.JSON);
        }
        if (!Objects.isNull(shards) && !Objects.isNull(replicas)) {
            request.settings(Settings.builder().put("index.number_of_shards", shards.intValue()).put("index.number_of_replicas", replicas.intValue()));
        }
        if (StringUtils.hasText((String)alias)) {
            request.alias(new Alias(alias));
        }
        try {
            CreateIndexResponse createIndexResponse = client.indices().create(request, RequestOptions.DEFAULT);
            acknowledged = createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("create es index exception", (Throwable)e);
        }
        if (!acknowledged) {
            log.error("create es index fail");
            throw new RuntimeException("cannot auto create thread-pool state es index");
        }
        log.info("create es index success");
        this.isIndexExist.set(true);
    }

    public String getType() {
        return MonitorTypeEnum.ES.name().toLowerCase();
    }
}

