/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.monitor.elasticsearch;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.StringUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ElasticSearchClientHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchClientHolder.class);
    private static String host;
    private static String scheme;
    private static String userName;
    private static String password;
    private static RestHighLevelClient client;

    private static RestHighLevelClient initRestClient() {
        try {
            Environment environment = ApplicationContextHolder.getInstance().getEnvironment();
            host = environment.getProperty("es.thread-pool-state.host");
            scheme = environment.getProperty("es.thread-pool-state.schema");
            userName = environment.getProperty("es.thread-pool-state.userName");
            password = environment.getProperty("es.thread-pool-state.password");
            List<HttpHost> hosts = ElasticSearchClientHolder.parseHosts();
            client = StringUtil.isEmpty((CharSequence)userName) || StringUtil.isEmpty((CharSequence)password) ? new RestHighLevelClient(RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]))) : new RestHighLevelClient(RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0])).setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)ElasticSearchClientHolder.getCredentialsProvider())));
            log.info("[ES RestHighLevelClient] success to connect es\uff01host:{},scheme:{}", (Object)host, (Object)scheme);
            return client;
        }
        catch (Exception ex) {
            log.error("[ES RestHighLevelClient] fail to connect es! cause:", (Throwable)ex);
            return null;
        }
    }

    private static BasicCredentialsProvider getCredentialsProvider() {
        if (StringUtil.isNotEmpty((CharSequence)userName) && StringUtil.isNotEmpty((CharSequence)password)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            return credentialsProvider;
        }
        return null;
    }

    public static RestHighLevelClient getClient() {
        return null == client ? ElasticSearchClientHolder.initRestClient() : client;
    }

    private static List<HttpHost> parseHosts() {
        String[] hostAndPorts = host.split(",");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (String hostAndPort : hostAndPorts) {
            hostAndPort = hostAndPort.trim();
            hosts.add(new HttpHost(hostAndPort.split(":")[0], Integer.parseInt(hostAndPort.split(":")[1]), scheme));
        }
        return hosts;
    }
}

