/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.monitor.elasticsearch;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.BeanUtil;
import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.monitor.base.AbstractDynamicThreadPoolMonitor;
import cn.hippo4j.monitor.base.MonitorTypeEnum;
import cn.hippo4j.monitor.elasticsearch.ElasticSearchClientHolder;
import cn.hippo4j.monitor.elasticsearch.model.ElasticSearchThreadPoolRunStateInfo;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DynamicThreadPoolElasticSearchMonitorHandler
extends AbstractDynamicThreadPoolMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolElasticSearchMonitorHandler.class);
    private AtomicBoolean isIndexExist = null;

    protected void execute(ThreadPoolRunStateInfo poolRunStateInfo) {
        ElasticSearchThreadPoolRunStateInfo esThreadPoolRunStateInfo = (ElasticSearchThreadPoolRunStateInfo)((Object)BeanUtil.convert((Object)poolRunStateInfo, ElasticSearchThreadPoolRunStateInfo.class));
        Environment environment = ApplicationContextHolder.getInstance().getEnvironment();
        String indexName = environment.getProperty("es.thread-pool-state.index.name", "thread-pool-state");
        String applicationName = environment.getProperty("spring.application.name", "application");
        if (!this.isExists(indexName)) {
            List rawMapping = FileUtil.readLines((String)Thread.currentThread().getContextClassLoader().getResource("mapping.json").getPath(), (Charset)StandardCharsets.UTF_8);
            String mapping = String.join((CharSequence)" ", rawMapping);
            this.createIndex(EsIndex.builder().index(indexName).type("_doc").mapping(mapping).build());
        }
        esThreadPoolRunStateInfo.setApplicationName(applicationName);
        esThreadPoolRunStateInfo.setId(indexName + "-" + System.currentTimeMillis());
        this.log2Es(esThreadPoolRunStateInfo, indexName);
    }

    public void log2Es(ElasticSearchThreadPoolRunStateInfo esThreadPoolRunStateInfo, String indexName) {
        RestHighLevelClient client = ElasticSearchClientHolder.getClient();
        try {
            IndexRequest request = new IndexRequest(indexName, "_doc");
            request.id(esThreadPoolRunStateInfo.getId());
            String stateJson = JSONUtil.toJSONString((Object)((Object)esThreadPoolRunStateInfo));
            request.source(stateJson, XContentType.JSON);
            IndexResponse response = client.index(request, RequestOptions.DEFAULT);
            log.info("write thread-pool state to es, id is :{}", (Object)response.getId());
        }
        catch (Exception ex) {
            log.error("es index error, the exception was thrown in create index. name:{},type:{},id:{}. {} ", new Object[]{indexName, "_doc", esThreadPoolRunStateInfo.getId(), ex});
        }
    }

    public synchronized boolean isExists(String index) {
        if (Objects.isNull(this.isIndexExist)) {
            boolean exists = false;
            GetIndexRequest request = new GetIndexRequest(new String[]{index});
            try {
                RestHighLevelClient client = ElasticSearchClientHolder.getClient();
                exists = client.indices().exists(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                log.error("check es index fail");
            }
            this.isIndexExist = new AtomicBoolean(exists);
        }
        return this.isIndexExist.get();
    }

    public void createIndex(EsIndex esIndex) {
        RestHighLevelClient client = ElasticSearchClientHolder.getClient();
        boolean acknowledged = false;
        CreateIndexRequest request = new CreateIndexRequest(esIndex.getIndex());
        if (StringUtils.hasText((String)esIndex.getMapping())) {
            request.mapping(esIndex.getType(), esIndex.getMapping(), XContentType.JSON);
        }
        if (!Objects.isNull(esIndex.getShards()) && !Objects.isNull(esIndex.getReplicas())) {
            request.settings(Settings.builder().put("index.number_of_shards", esIndex.getShards().intValue()).put("index.number_of_replicas", esIndex.getReplicas().intValue()));
        }
        if (StringUtils.hasText((String)esIndex.getAlias())) {
            request.alias(new Alias(esIndex.getAlias()));
        }
        try {
            CreateIndexResponse createIndexResponse = client.indices().create(request, RequestOptions.DEFAULT);
            acknowledged = createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("create es index exception", (Throwable)e);
        }
        if (!acknowledged) {
            log.error("create es index fail");
            throw new RuntimeException("cannot auto create thread-pool state es index");
        }
        log.info("create es index success");
        this.isIndexExist.set(true);
    }

    public String getType() {
        return MonitorTypeEnum.ELASTICSEARCH.name().toLowerCase();
    }

    private static class EsIndex {
        String index;
        String type;
        String mapping;
        Integer shards;
        Integer replicas;
        String alias;

        @Generated
        EsIndex(String index, String type, String mapping, Integer shards, Integer replicas, String alias) {
            this.index = index;
            this.type = type;
            this.mapping = mapping;
            this.shards = shards;
            this.replicas = replicas;
            this.alias = alias;
        }

        @Generated
        public static EsIndexBuilder builder() {
            return new EsIndexBuilder();
        }

        @Generated
        public String getIndex() {
            return this.index;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getMapping() {
            return this.mapping;
        }

        @Generated
        public Integer getShards() {
            return this.shards;
        }

        @Generated
        public Integer getReplicas() {
            return this.replicas;
        }

        @Generated
        public String getAlias() {
            return this.alias;
        }

        @Generated
        public static class EsIndexBuilder {
            @Generated
            private String index;
            @Generated
            private String type;
            @Generated
            private String mapping;
            @Generated
            private Integer shards;
            @Generated
            private Integer replicas;
            @Generated
            private String alias;

            @Generated
            EsIndexBuilder() {
            }

            @Generated
            public EsIndexBuilder index(String index) {
                this.index = index;
                return this;
            }

            @Generated
            public EsIndexBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public EsIndexBuilder mapping(String mapping) {
                this.mapping = mapping;
                return this;
            }

            @Generated
            public EsIndexBuilder shards(Integer shards) {
                this.shards = shards;
                return this;
            }

            @Generated
            public EsIndexBuilder replicas(Integer replicas) {
                this.replicas = replicas;
                return this;
            }

            @Generated
            public EsIndexBuilder alias(String alias) {
                this.alias = alias;
                return this;
            }

            @Generated
            public EsIndex build() {
                return new EsIndex(this.index, this.type, this.mapping, this.shards, this.replicas, this.alias);
            }

            @Generated
            public String toString() {
                return "DynamicThreadPoolElasticSearchMonitorHandler.EsIndex.EsIndexBuilder(index=" + this.index + ", type=" + this.type + ", mapping=" + this.mapping + ", shards=" + this.shards + ", replicas=" + this.replicas + ", alias=" + this.alias + ")";
            }
        }
    }
}

