/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform;

import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.Singleton;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.toolkit.http.HttpUtil;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.enums.NotifyPlatformEnum;
import cn.hippo4j.message.enums.NotifyTypeEnum;
import cn.hippo4j.message.request.AlarmNotifyRequest;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.SendMessageHandler;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LarkSendMessageHandler
implements SendMessageHandler<AlarmNotifyRequest, ChangeParameterNotifyRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LarkSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.LARK.name();
    }

    @Override
    public void sendAlarmMessage(NotifyConfigDTO notifyConfig, AlarmNotifyRequest alarmNotifyRequest) {
        String afterReceives = this.getReceives(notifyConfig.getReceives());
        String larkAlarmTxtKey = "message/robot/dynamic-thread-pool/lark-alarm.json";
        String larkAlarmTxt = (String)Singleton.get((String)larkAlarmTxtKey, () -> FileUtil.readUtf8String((String)larkAlarmTxtKey));
        String larkAlarmTimeoutReplaceJsonKey = "message/robot/dynamic-thread-pool/lark-alarm-timeout-replace.json";
        String larkAlarmTimeoutReplaceJson = (String)Singleton.get((String)larkAlarmTimeoutReplaceJsonKey, () -> FileUtil.readUtf8String((String)larkAlarmTimeoutReplaceJsonKey));
        if (Objects.equals((Object)alarmNotifyRequest.getNotifyTypeEnum(), (Object)NotifyTypeEnum.TIMEOUT)) {
            String larkAlarmTimeoutReplaceTxt;
            String executeTimeoutTrace = alarmNotifyRequest.getExecuteTimeoutTrace();
            String larkAlarmTimoutTraceReplaceJsonKey = "message/robot/dynamic-thread-pool/lark-alarm-trace-replace.json";
            String larkAlarmTimoutTraceReplaceJson = (String)Singleton.get((String)larkAlarmTimoutTraceReplaceJsonKey, () -> FileUtil.readUtf8String((String)larkAlarmTimoutTraceReplaceJsonKey));
            if (StringUtil.isNotBlank((CharSequence)executeTimeoutTrace)) {
                String larkAlarmTimoutTraceReplaceTxt = String.format(larkAlarmTimoutTraceReplaceJson, executeTimeoutTrace);
                larkAlarmTimeoutReplaceTxt = StringUtil.replace((String)larkAlarmTimeoutReplaceJson, (String)larkAlarmTimoutTraceReplaceJson, (String)larkAlarmTimoutTraceReplaceTxt);
            } else {
                larkAlarmTimeoutReplaceTxt = StringUtil.replace((String)larkAlarmTimeoutReplaceJson, (String)larkAlarmTimoutTraceReplaceJson, (String)"");
            }
            larkAlarmTimeoutReplaceTxt = String.format(larkAlarmTimeoutReplaceTxt, alarmNotifyRequest.getExecuteTime(), alarmNotifyRequest.getExecuteTimeOut());
            larkAlarmTxt = StringUtil.replace((String)larkAlarmTxt, (String)larkAlarmTimeoutReplaceJson, (String)larkAlarmTimeoutReplaceTxt);
        } else {
            larkAlarmTxt = StringUtil.replace((String)larkAlarmTxt, (String)larkAlarmTimeoutReplaceJson, (String)"");
        }
        String text = String.format(larkAlarmTxt, new Object[]{alarmNotifyRequest.getActive(), alarmNotifyRequest.getNotifyTypeEnum(), alarmNotifyRequest.getThreadPoolId(), alarmNotifyRequest.getAppName(), alarmNotifyRequest.getIdentify(), alarmNotifyRequest.getCorePoolSize(), alarmNotifyRequest.getMaximumPoolSize(), alarmNotifyRequest.getPoolSize(), alarmNotifyRequest.getActiveCount(), alarmNotifyRequest.getLargestPoolSize(), alarmNotifyRequest.getCompletedTaskCount(), alarmNotifyRequest.getQueueName(), alarmNotifyRequest.getCapacity(), alarmNotifyRequest.getQueueSize(), alarmNotifyRequest.getRemainingCapacity(), alarmNotifyRequest.getRejectedExecutionHandlerName(), alarmNotifyRequest.getRejectCountNum(), afterReceives, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), notifyConfig.getInterval()});
        this.execute(notifyConfig.getSecretKey(), text);
    }

    @Override
    public void sendChangeMessage(NotifyConfigDTO notifyConfig, ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        String afterReceives = this.getReceives(notifyConfig.getReceives());
        String larkNoticeJsonKey = "message/robot/dynamic-thread-pool/lark-config.json";
        String larkNoticeJson = (String)Singleton.get((String)larkNoticeJsonKey, () -> FileUtil.readUtf8String((String)larkNoticeJsonKey));
        String text = String.format(larkNoticeJson, changeParameterNotifyRequest.getActive(), threadPoolId, changeParameterNotifyRequest.getAppName(), changeParameterNotifyRequest.getIdentify(), changeParameterNotifyRequest.getBeforeCorePoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowCorePoolSize(), changeParameterNotifyRequest.getBeforeMaximumPoolSize() + "  \u27b2  " + changeParameterNotifyRequest.getNowMaximumPoolSize(), changeParameterNotifyRequest.getBeforeAllowsCoreThreadTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowAllowsCoreThreadTimeOut(), changeParameterNotifyRequest.getBeforeKeepAliveTime() + "  \u27b2  " + changeParameterNotifyRequest.getNowKeepAliveTime(), changeParameterNotifyRequest.getBlockingQueueName(), changeParameterNotifyRequest.getBeforeQueueCapacity() + "  \u27b2  " + changeParameterNotifyRequest.getNowQueueCapacity(), changeParameterNotifyRequest.getBeforeExecuteTimeOut() + "  \u27b2  " + changeParameterNotifyRequest.getNowExecuteTimeOut(), changeParameterNotifyRequest.getBeforeRejectedName(), changeParameterNotifyRequest.getNowRejectedName(), afterReceives, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        this.execute(notifyConfig.getSecretKey(), text);
    }

    private String getReceives(String receives) {
        if (StringUtil.isBlank((CharSequence)receives)) {
            return "";
        }
        return Arrays.stream(receives.split(",")).map(receive -> StringUtil.startWith((String)receive, (String)"ou_") ? String.format("<at id='%s'></at>", receive) : String.format("<at id=''>%s</at>", receive)).collect(Collectors.joining(" "));
    }

    private void execute(String secretKey, String text) {
        String serverUrl = "https://open.feishu.cn/open-apis/bot/v2/hook/" + secretKey;
        try {
            HttpUtil.postJson((String)serverUrl, (String)text);
        }
        catch (Exception ex) {
            log.error("Lark failed to send message", (Throwable)ex);
        }
    }

    @Generated
    public LarkSendMessageHandler() {
    }
}

