/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.service;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.message.api.NotifyConfigBuilder;
import cn.hippo4j.message.dto.AlarmControlDTO;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.enums.NotifyTypeEnum;
import cn.hippo4j.message.request.AlarmNotifyRequest;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.AlarmControlHandler;
import cn.hippo4j.message.service.Hippo4jSendMessageService;
import cn.hippo4j.message.service.SendMessageHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class Hippo4jBaseSendMessageService
implements Hippo4jSendMessageService,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Hippo4jBaseSendMessageService.class);
    private final NotifyConfigBuilder notifyConfigBuilder;
    private final AlarmControlHandler alarmControlHandler;
    public final Map<String, List<NotifyConfigDTO>> notifyConfigs = new HashMap<String, List<NotifyConfigDTO>>();
    private final Map<String, SendMessageHandler> sendMessageHandlers = new HashMap<String, SendMessageHandler>();

    @Override
    public void sendAlarmMessage(NotifyTypeEnum typeEnum, AlarmNotifyRequest alarmNotifyRequest) {
        String threadPoolId = alarmNotifyRequest.getThreadPoolId();
        String buildKey = threadPoolId + "+" + "ALARM";
        List<NotifyConfigDTO> notifyList = this.notifyConfigs.get(buildKey);
        if (CollectionUtil.isEmpty(notifyList)) {
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key: [{}]", (Object)threadPoolId);
                    return;
                }
                if (this.isSendAlarm(each.getTpId(), each.getPlatform(), typeEnum)) {
                    alarmNotifyRequest.setNotifyTypeEnum(typeEnum);
                    messageHandler.sendAlarmMessage((NotifyConfigDTO)each, alarmNotifyRequest);
                }
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool alarm notification. key: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    @Override
    public void sendChangeMessage(ChangeParameterNotifyRequest changeParameterNotifyRequest) {
        String threadPoolId = changeParameterNotifyRequest.getThreadPoolId();
        String buildKey = threadPoolId + "+" + "CONFIG";
        List<NotifyConfigDTO> notifyList = this.notifyConfigs.get(buildKey);
        if (CollectionUtil.isEmpty(notifyList)) {
            log.warn("Please configure alarm notification on the server. key: [{}]", (Object)threadPoolId);
            return;
        }
        notifyList.forEach(each -> {
            try {
                SendMessageHandler messageHandler = this.sendMessageHandlers.get(each.getPlatform());
                if (messageHandler == null) {
                    log.warn("Please configure alarm notification on the server. key: [{}]", (Object)threadPoolId);
                    return;
                }
                messageHandler.sendChangeMessage((NotifyConfigDTO)each, changeParameterNotifyRequest);
            }
            catch (Exception ex) {
                log.warn("Failed to send thread pool change notification. key: [{}]", (Object)threadPoolId, (Object)ex);
            }
        });
    }

    private boolean isSendAlarm(String threadPoolId, String platform, NotifyTypeEnum typeEnum) {
        AlarmControlDTO alarmControl = AlarmControlDTO.builder().threadPool(threadPoolId).platform(platform).typeEnum(typeEnum).build();
        return this.alarmControlHandler.isSendAlarm(alarmControl);
    }

    public void run(String ... args) throws Exception {
        Map sendMessageHandlerMap = ApplicationContextHolder.getBeansOfType(SendMessageHandler.class);
        sendMessageHandlerMap.values().forEach(each -> this.sendMessageHandlers.put(each.getType(), (SendMessageHandler)each));
        Map<String, List<NotifyConfigDTO>> buildNotify = this.notifyConfigBuilder.buildNotify();
        this.notifyConfigs.putAll(buildNotify);
    }

    public synchronized void putPlatform(Map<String, List<NotifyConfigDTO>> notifyConfigs) {
        this.notifyConfigs.putAll(notifyConfigs);
    }

    public Hippo4jBaseSendMessageService(NotifyConfigBuilder notifyConfigBuilder, AlarmControlHandler alarmControlHandler) {
        this.notifyConfigBuilder = notifyConfigBuilder;
        this.alarmControlHandler = alarmControlHandler;
    }

    public Map<String, List<NotifyConfigDTO>> getNotifyConfigs() {
        return this.notifyConfigs;
    }
}

