/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform;

import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.Singleton;
import cn.hippo4j.message.enums.NotifyPlatformEnum;
import cn.hippo4j.message.platform.base.AbstractRobotSendMessageHandler;
import cn.hippo4j.message.platform.base.RobotMessageActualContent;
import cn.hippo4j.message.platform.base.RobotMessageExecuteDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class WeChatSendMessageHandler
extends AbstractRobotSendMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(WeChatSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.WECHAT.name();
    }

    @Override
    protected RobotMessageActualContent buildMessageActualContent() {
        String weChatAlarmTxtKey = "message/robot/dynamic-thread-pool/wechat-alarm.txt";
        String weChatConfigTxtKey = "message/robot/dynamic-thread-pool/wechat-config.txt";
        return RobotMessageActualContent.builder().receiveSeparator("><@").changeSeparator("  \u27b2  ").replaceTxt("\n> \u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%s / ms \n> \u8d85\u65f6\u65f6\u95f4\uff1a%s / ms \n> \u94fe\u8def\u4fe1\u606f\uff1a%s ").traceReplaceTxt("\n> \u94fe\u8def\u4fe1\u606f\uff1a%s ").alarmMessageContent((String)Singleton.get((String)weChatAlarmTxtKey, () -> FileUtil.readUtf8String((String)weChatAlarmTxtKey))).configMessageContent((String)Singleton.get((String)weChatConfigTxtKey, () -> FileUtil.readUtf8String((String)weChatConfigTxtKey))).build();
    }

    @Override
    protected void execute(RobotMessageExecuteDTO robotMessageExecuteDTO) {
        String serverUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + robotMessageExecuteDTO.getNotifyConfig().getSecretKey();
        try {
            WeChatReqDTO weChatReq = new WeChatReqDTO();
            weChatReq.setMsgtype("markdown");
            Markdown markdown = new Markdown();
            markdown.setContent(robotMessageExecuteDTO.getText());
            weChatReq.setMarkdown(markdown);
            RestTemplate template = new RestTemplate();
            template.postForObject(serverUrl, (Object)weChatReq, Object.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("WeChat failed to send message", (Throwable)ex);
        }
    }

    public static class Markdown {
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Markdown)) {
                return false;
            }
            Markdown other = (Markdown)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Markdown;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "WeChatSendMessageHandler.Markdown(content=" + this.getContent() + ")";
        }
    }

    public static class WeChatReqDTO {
        private String msgtype;
        private Markdown markdown;

        public String getMsgtype() {
            return this.msgtype;
        }

        public Markdown getMarkdown() {
            return this.markdown;
        }

        public WeChatReqDTO setMsgtype(String msgtype) {
            this.msgtype = msgtype;
            return this;
        }

        public WeChatReqDTO setMarkdown(Markdown markdown) {
            this.markdown = markdown;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatReqDTO)) {
                return false;
            }
            WeChatReqDTO other = (WeChatReqDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$msgtype = this.getMsgtype();
            String other$msgtype = other.getMsgtype();
            if (this$msgtype == null ? other$msgtype != null : !this$msgtype.equals(other$msgtype)) {
                return false;
            }
            Markdown this$markdown = this.getMarkdown();
            Markdown other$markdown = other.getMarkdown();
            return !(this$markdown == null ? other$markdown != null : !((Object)this$markdown).equals(other$markdown));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatReqDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $msgtype = this.getMsgtype();
            result = result * 59 + ($msgtype == null ? 43 : $msgtype.hashCode());
            Markdown $markdown = this.getMarkdown();
            result = result * 59 + ($markdown == null ? 43 : ((Object)$markdown).hashCode());
            return result;
        }

        public String toString() {
            return "WeChatSendMessageHandler.WeChatReqDTO(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ")";
        }
    }
}

