/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.message.platform;

import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.FileUtil;
import cn.hippo4j.common.toolkit.Singleton;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.message.dto.NotifyConfigDTO;
import cn.hippo4j.message.enums.NotifyPlatformEnum;
import cn.hippo4j.message.platform.base.AbstractRobotSendMessageHandler;
import cn.hippo4j.message.platform.base.RobotMessageActualContent;
import cn.hippo4j.message.platform.base.RobotMessageExecuteDTO;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingSendMessageHandler
extends AbstractRobotSendMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DingSendMessageHandler.class);

    @Override
    public String getType() {
        return NotifyPlatformEnum.DING.name();
    }

    @Override
    protected RobotMessageActualContent buildMessageActualContent() {
        String dingAlarmTxtKey = "message/robot/dynamic-thread-pool/ding-alarm.txt";
        String dingConfigTxtKey = "message/robot/dynamic-thread-pool/ding-config.txt";
        RobotMessageActualContent robotMessageActualContent = RobotMessageActualContent.builder().receiveSeparator(", @").changeSeparator(" -> ").replaceTxt("<font color=#708090 size=2>\u4efb\u52a1\u6267\u884c\u65f6\u95f4\uff1a%d / ms </font> \n\n <font color=#708090 size=2>\u8d85\u65f6\u65f6\u95f4\uff1a%d / ms</font> \n\n <font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n  --- \n\n ").traceReplaceTxt("<font color=#708090 size=2>\u94fe\u8def\u4fe1\u606f\uff1a%s</font> \n\n ").alarmMessageContent((String)Singleton.get((String)dingAlarmTxtKey, () -> FileUtil.readUtf8String((String)dingAlarmTxtKey))).configMessageContent((String)Singleton.get((String)dingConfigTxtKey, () -> FileUtil.readUtf8String((String)dingConfigTxtKey))).build();
        return robotMessageActualContent;
    }

    @Override
    protected void execute(RobotMessageExecuteDTO robotMessageExecuteDTO) {
        NotifyConfigDTO notifyConfig = robotMessageExecuteDTO.getNotifyConfig();
        String serverUrl = "https://oapi.dingtalk.com/robot/send?access_token=" + notifyConfig.getSecretKey();
        String secret = notifyConfig.getSecret();
        if (StringUtil.isNotBlank((CharSequence)secret)) {
            long timestamp = System.currentTimeMillis();
            String stringToSign = timestamp + "\n" + secret;
            try {
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8.name());
                serverUrl = serverUrl + "&timestamp=" + timestamp + "&sign=" + sign;
            }
            catch (Exception ex) {
                log.error("Failed to sign the message sent by nailing.", (Throwable)ex);
            }
        }
        DefaultDingTalkClient dingTalkClient = new DefaultDingTalkClient(serverUrl);
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype("markdown");
        OapiRobotSendRequest.Markdown markdown = new OapiRobotSendRequest.Markdown();
        markdown.setTitle(Objects.equals(notifyConfig.getType(), "CONFIG") ? "\u52a8\u6001\u7ebf\u7a0b\u6c60\u901a\u77e5" : "\u52a8\u6001\u7ebf\u7a0b\u6c60\u544a\u8b66");
        markdown.setText(robotMessageExecuteDTO.getText());
        OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
        at.setAtMobiles((List)CollectionUtil.newArrayList((Object[])notifyConfig.getReceives().split(",")));
        request.setAt(at);
        request.setMarkdown(markdown);
        try {
            dingTalkClient.execute((TaobaoRequest)request);
        }
        catch (ApiException ex) {
            log.error("Ding failed to send message", (Throwable)ex);
        }
    }
}

