/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.handler;

import cn.hippo4j.core.config.BootstrapPropertiesInterface;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;

public class DynamicThreadPoolBannerHandler
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolBannerHandler.class);
    @NonNull
    private final BootstrapPropertiesInterface properties;
    private final String DYNAMIC_THREAD_POOL = " :: Dynamic ThreadPool :: ";
    private final String HIPPO4J_GITHUB = "GitHub:  https://github.com/mabaiwan/hippo4j";
    private final String HIPPO4J_SITE = "Site:    https://hippo4j.cn";
    private final int STRAP_LINE_SIZE = 50;

    public void afterPropertiesSet() {
        this.printBanner();
    }

    private void printBanner() {
        String banner = "___                       _      _____ ___ \n|   \\ _  _ _ _  __ _ _ __ (_)__  |_   _| _ \\\n| |) | || | ' \\/ _` | '  \\| / _|   | | |  _/\n|___/ \\_, |_||_\\__,_|_|_|_|_\\__|   |_| |_|  \n      |__/                                  \n";
        if (this.properties.getBanner().booleanValue()) {
            String version = DynamicThreadPoolBannerHandler.getVersion();
            version = version != null ? " (v" + version + ")" : "no version.";
            StringBuilder padding = new StringBuilder();
            while (padding.length() < 50 - (version.length() + " :: Dynamic ThreadPool :: ".length())) {
                padding.append(" ");
            }
            System.out.println(AnsiOutput.toString((Object[])new Object[]{banner, AnsiColor.GREEN, " :: Dynamic ThreadPool :: ", AnsiColor.DEFAULT, padding.toString(), AnsiStyle.FAINT, version, "\n\n", "GitHub:  https://github.com/mabaiwan/hippo4j", "\n", "Site:    https://hippo4j.cn", "\n"}));
        }
    }

    public static String getVersion() {
        Package pkg = DynamicThreadPoolBannerHandler.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : "";
    }

    public DynamicThreadPoolBannerHandler(@NonNull BootstrapPropertiesInterface properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
    }
}

