/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.web;

import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import cn.hippo4j.core.executor.web.AbstractWebThreadPoolService;
import cn.hippo4j.core.toolkit.CalculateUtil;
import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(TomcatWebThreadPoolHandler.class);
    private final AtomicBoolean cacheFlag = new AtomicBoolean(Boolean.FALSE);
    private static String EXCEPTION_MESSAGE;
    private final AbstractThreadPoolRuntime webThreadPoolRunStateHandler;

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        if (this.cacheFlag.get()) {
            log.warn("Exception getting Tomcat thread pool. Exception message :: {}", (Object)EXCEPTION_MESSAGE);
            return null;
        }
        Executor tomcatExecutor = null;
        try {
            tomcatExecutor = ((TomcatWebServer)webServer).getTomcat().getConnector().getProtocolHandler().getExecutor();
        }
        catch (Exception ex) {
            this.cacheFlag.set(Boolean.TRUE);
            EXCEPTION_MESSAGE = ex.getMessage();
            log.error("Failed to get Tomcat thread pool. Message :: {}", (Object)EXCEPTION_MESSAGE);
        }
        return tomcatExecutor;
    }

    @Override
    public ThreadPoolBaseInfo simpleInfo() {
        ThreadPoolBaseInfo poolBaseInfo = new ThreadPoolBaseInfo();
        ThreadPoolExecutor tomcatThreadPoolExecutor = (ThreadPoolExecutor)this.executor;
        int corePoolSize = tomcatThreadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = tomcatThreadPoolExecutor.getMaximumPoolSize();
        long keepAliveTime = tomcatThreadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
        BlockingQueue blockingQueue = tomcatThreadPoolExecutor.getQueue();
        int queueSize = blockingQueue.size();
        int remainingCapacity = blockingQueue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        String rejectedExecutionHandlerName = this.executor instanceof java.util.concurrent.ThreadPoolExecutor ? ((java.util.concurrent.ThreadPoolExecutor)this.executor).getRejectedExecutionHandler().getClass().getSimpleName() : tomcatThreadPoolExecutor.getRejectedExecutionHandler().getClass().getSimpleName();
        poolBaseInfo.setCoreSize(Integer.valueOf(corePoolSize));
        poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
        poolBaseInfo.setQueueType(blockingQueue.getClass().getSimpleName());
        poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        poolBaseInfo.setRejectedName(rejectedExecutionHandlerName);
        return poolBaseInfo;
    }

    @Override
    public ThreadPoolParameter getWebThreadPoolParameter() {
        ThreadPoolParameterInfo parameterInfo = new ThreadPoolParameterInfo();
        try {
            ThreadPoolExecutor tomcatThreadPoolExecutor = (ThreadPoolExecutor)this.executor;
            int minThreads = tomcatThreadPoolExecutor.getCorePoolSize();
            int maxThreads = tomcatThreadPoolExecutor.getMaximumPoolSize();
            long keepAliveTime = tomcatThreadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            parameterInfo.setCoreSize(Integer.valueOf(minThreads));
            parameterInfo.setMaxSize(Integer.valueOf(maxThreads));
            parameterInfo.setKeepAliveTime(Integer.valueOf((int)keepAliveTime));
        }
        catch (Exception ex) {
            log.error("Failed to get the tomcat thread pool parameter.", (Throwable)ex);
        }
        return parameterInfo;
    }

    @Override
    public ThreadPoolRunStateInfo getWebRunStateInfo() {
        if (this.executor instanceof java.util.concurrent.ThreadPoolExecutor) {
            return this.webThreadPoolRunStateHandler.getPoolRunState(null, this.executor);
        }
        ThreadPoolRunStateInfo runStateInfo = new ThreadPoolRunStateInfo();
        ThreadPoolExecutor tomcatThreadPoolExecutor = (ThreadPoolExecutor)this.executor;
        int corePoolSize = tomcatThreadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = tomcatThreadPoolExecutor.getMaximumPoolSize();
        int poolSize = tomcatThreadPoolExecutor.getPoolSize();
        int activeCount = tomcatThreadPoolExecutor.getActiveCount();
        int largestPoolSize = tomcatThreadPoolExecutor.getLargestPoolSize();
        long completedTaskCount = tomcatThreadPoolExecutor.getCompletedTaskCount();
        String currentLoad = CalculateUtil.divide(activeCount, maximumPoolSize) + "";
        String peakLoad = CalculateUtil.divide(largestPoolSize, maximumPoolSize) + "";
        BlockingQueue queue = tomcatThreadPoolExecutor.getQueue();
        int queueSize = queue.size();
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        runStateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        runStateInfo.setPoolSize(Integer.valueOf(poolSize));
        runStateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        runStateInfo.setActiveSize(Integer.valueOf(activeCount));
        runStateInfo.setCurrentLoad(currentLoad);
        runStateInfo.setPeakLoad(peakLoad);
        runStateInfo.setQueueType(queueType);
        runStateInfo.setQueueSize(Integer.valueOf(queueSize));
        runStateInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        runStateInfo.setQueueRemainingCapacity(Integer.valueOf(remainingCapacity));
        runStateInfo.setLargestPoolSize(Integer.valueOf(largestPoolSize));
        runStateInfo.setCompletedTaskCount(Long.valueOf(completedTaskCount));
        runStateInfo.setClientLastRefreshTime(DateUtil.formatDateTime((Date)new Date()));
        runStateInfo.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return this.webThreadPoolRunStateHandler.supplement(runStateInfo);
    }

    @Override
    public void updateWebThreadPool(ThreadPoolParameterInfo threadPoolParameterInfo) {
        try {
            ThreadPoolExecutor tomcatThreadPoolExecutor = (ThreadPoolExecutor)this.executor;
            int originalCoreSize = tomcatThreadPoolExecutor.getCorePoolSize();
            int originalMaximumPoolSize = tomcatThreadPoolExecutor.getMaximumPoolSize();
            long originalKeepAliveTime = tomcatThreadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            tomcatThreadPoolExecutor.setCorePoolSize(threadPoolParameterInfo.corePoolSizeAdapt().intValue());
            tomcatThreadPoolExecutor.setMaximumPoolSize(threadPoolParameterInfo.maximumPoolSizeAdapt().intValue());
            tomcatThreadPoolExecutor.setKeepAliveTime((long)threadPoolParameterInfo.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
            log.info("[TOMCAT] Changed web thread pool. corePoolSize :: [{}], maximumPoolSize :: [{}], keepAliveTime :: [{}]", new Object[]{String.format("%s => %s", originalCoreSize, threadPoolParameterInfo.corePoolSizeAdapt()), String.format("%s => %s", originalMaximumPoolSize, threadPoolParameterInfo.maximumPoolSizeAdapt()), String.format("%s => %s", originalKeepAliveTime, threadPoolParameterInfo.getKeepAliveTime())});
        }
        catch (Exception ex) {
            log.error("Failed to modify the Tomcat thread pool parameter.", (Throwable)ex);
        }
    }

    public TomcatWebThreadPoolHandler(AbstractThreadPoolRuntime webThreadPoolRunStateHandler) {
        this.webThreadPoolRunStateHandler = webThreadPoolRunStateHandler;
    }
}

