/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.state;

import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.toolkit.CalculateUtil;
import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class AbstractThreadPoolRuntime {
    public abstract ThreadPoolRunStateInfo supplement(ThreadPoolRunStateInfo var1);

    public ThreadPoolRunStateInfo getPoolRunState(String threadPoolId) {
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        ThreadPoolExecutor pool = executorService.getExecutor();
        return this.getPoolRunState(threadPoolId, pool);
    }

    public ThreadPoolRunStateInfo getPoolRunState(String threadPoolId, Executor executor) {
        ThreadPoolRunStateInfo stateInfo = new ThreadPoolRunStateInfo();
        ThreadPoolExecutor pool = (ThreadPoolExecutor)executor;
        int corePoolSize = pool.getCorePoolSize();
        int maximumPoolSize = pool.getMaximumPoolSize();
        int poolSize = pool.getPoolSize();
        int activeCount = pool.getActiveCount();
        int largestPoolSize = pool.getLargestPoolSize();
        long completedTaskCount = pool.getCompletedTaskCount();
        String currentLoad = CalculateUtil.divide(activeCount, maximumPoolSize) + "";
        String peakLoad = CalculateUtil.divide(largestPoolSize, maximumPoolSize) + "";
        BlockingQueue<Runnable> queue = pool.getQueue();
        int queueSize = queue.size();
        String queueType = queue.getClass().getSimpleName();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        stateInfo.setCoreSize(Integer.valueOf(corePoolSize));
        stateInfo.setTpId(threadPoolId);
        stateInfo.setPoolSize(Integer.valueOf(poolSize));
        stateInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        stateInfo.setActiveSize(Integer.valueOf(activeCount));
        stateInfo.setCurrentLoad(currentLoad);
        stateInfo.setPeakLoad(peakLoad);
        stateInfo.setQueueType(queueType);
        stateInfo.setQueueSize(Integer.valueOf(queueSize));
        stateInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        stateInfo.setQueueRemainingCapacity(Integer.valueOf(remainingCapacity));
        stateInfo.setLargestPoolSize(Integer.valueOf(largestPoolSize));
        stateInfo.setCompletedTaskCount(Long.valueOf(completedTaskCount));
        long rejectCount = pool instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)pool).getRejectCountNum() : -1L;
        stateInfo.setRejectCount(Long.valueOf(rejectCount));
        stateInfo.setClientLastRefreshTime(DateUtil.formatDateTime((Date)new Date()));
        stateInfo.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return this.supplement(stateInfo);
    }
}

