/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.web;

import cn.hippo4j.common.model.ThreadPoolBaseInfo;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.ThreadPoolParameterInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import cn.hippo4j.core.executor.web.AbstractWebThreadPoolService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatWebThreadPoolHandler
extends AbstractWebThreadPoolService {
    private static final Logger log = LoggerFactory.getLogger(TomcatWebThreadPoolHandler.class);
    private final AtomicBoolean cacheFlag = new AtomicBoolean(Boolean.FALSE);
    private static String EXCEPTION_MESSAGE;
    private final AbstractThreadPoolRuntime webThreadPoolRunStateHandler;

    @Override
    protected Executor getWebThreadPoolByServer(WebServer webServer) {
        if (this.cacheFlag.get()) {
            log.warn("Exception getting Tomcat thread pool. Exception message :: {}", (Object)EXCEPTION_MESSAGE);
            return null;
        }
        Executor tomcatExecutor = null;
        try {
            tomcatExecutor = ((TomcatWebServer)webServer).getTomcat().getConnector().getProtocolHandler().getExecutor();
        }
        catch (Exception ex) {
            this.cacheFlag.set(Boolean.TRUE);
            EXCEPTION_MESSAGE = ex.getMessage();
            log.error("Failed to get Tomcat thread pool. Message :: {}", (Object)EXCEPTION_MESSAGE);
        }
        return tomcatExecutor;
    }

    @Override
    public ThreadPoolBaseInfo simpleInfo() {
        ThreadPoolBaseInfo poolBaseInfo = new ThreadPoolBaseInfo();
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
        int corePoolSize = threadPoolExecutor.getCorePoolSize();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor.getRejectedExecutionHandler();
        long keepAliveTime = threadPoolExecutor.getKeepAliveTime(TimeUnit.SECONDS);
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        int queueSize = queue.size();
        int remainingCapacity = queue.remainingCapacity();
        int queueCapacity = queueSize + remainingCapacity;
        poolBaseInfo.setCoreSize(Integer.valueOf(corePoolSize));
        poolBaseInfo.setMaximumSize(Integer.valueOf(maximumPoolSize));
        poolBaseInfo.setKeepAliveTime(Long.valueOf(keepAliveTime));
        poolBaseInfo.setQueueType(queue.getClass().getSimpleName());
        poolBaseInfo.setQueueCapacity(Integer.valueOf(queueCapacity));
        poolBaseInfo.setRejectedName(rejectedExecutionHandler.getClass().getSimpleName());
        return poolBaseInfo;
    }

    @Override
    public ThreadPoolParameter getWebThreadPoolParameter() {
        ThreadPoolParameterInfo parameterInfo = null;
        try {
            parameterInfo = new ThreadPoolParameterInfo();
            ThreadPoolExecutor tomcatExecutor = (ThreadPoolExecutor)this.executor;
            int minThreads = tomcatExecutor.getCorePoolSize();
            int maxThreads = tomcatExecutor.getMaximumPoolSize();
            long keepAliveTime = tomcatExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            parameterInfo.setCoreSize(Integer.valueOf(minThreads));
            parameterInfo.setMaxSize(Integer.valueOf(maxThreads));
            parameterInfo.setKeepAliveTime(Integer.valueOf((int)keepAliveTime));
        }
        catch (Exception ex) {
            log.error("Failed to get the tomcat thread pool parameter.", (Throwable)ex);
        }
        return parameterInfo;
    }

    @Override
    public ThreadPoolRunStateInfo getWebRunStateInfo() {
        return this.webThreadPoolRunStateHandler.getPoolRunState(null, this.executor);
    }

    @Override
    public void updateWebThreadPool(ThreadPoolParameterInfo threadPoolParameterInfo) {
        try {
            ThreadPoolExecutor tomcatExecutor = (ThreadPoolExecutor)this.executor;
            int originalCoreSize = tomcatExecutor.getCorePoolSize();
            int originalMaximumPoolSize = tomcatExecutor.getMaximumPoolSize();
            long originalKeepAliveTime = tomcatExecutor.getKeepAliveTime(TimeUnit.SECONDS);
            tomcatExecutor.setCorePoolSize(threadPoolParameterInfo.corePoolSizeAdapt());
            tomcatExecutor.setMaximumPoolSize(threadPoolParameterInfo.maximumPoolSizeAdapt());
            tomcatExecutor.setKeepAliveTime(threadPoolParameterInfo.getKeepAliveTime().intValue(), TimeUnit.SECONDS);
            log.info("[TOMCAT] Changed web thread pool. corePoolSize :: [{}], maximumPoolSize :: [{}], keepAliveTime :: [{}]", new Object[]{String.format("%s => %s", originalCoreSize, threadPoolParameterInfo.corePoolSizeAdapt()), String.format("%s => %s", originalMaximumPoolSize, threadPoolParameterInfo.maximumPoolSizeAdapt()), String.format("%s => %s", originalKeepAliveTime, threadPoolParameterInfo.getKeepAliveTime())});
        }
        catch (Exception ex) {
            log.error("Failed to modify the Tomcat thread pool parameter.", (Throwable)ex);
        }
    }

    public TomcatWebThreadPoolHandler(AbstractThreadPoolRuntime webThreadPoolRunStateHandler) {
        this.webThreadPoolRunStateHandler = webThreadPoolRunStateHandler;
    }
}

