/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.support;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedPolicies {
    private static final Logger log = LoggerFactory.getLogger(RejectedPolicies.class);

    public static class SyncPutQueuePolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                return;
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                log.error("Adding Queue task to thread pool failed.", (Throwable)e);
            }
        }
    }

    public static class RunsOldestTaskPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                return;
            }
            BlockingQueue<Runnable> workQueue = executor.getQueue();
            Runnable firstWork = (Runnable)workQueue.poll();
            boolean newTaskAdd = workQueue.offer(r);
            if (firstWork != null) {
                firstWork.run();
            }
            if (!newTaskAdd) {
                executor.execute(r);
            }
        }
    }
}

